--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Logging_Flags;

limited with Nomo.Interpreter.Storages;

private with Nomo.Interpreter.Landmark_Rules.Logging;

private with Nomo.Interpreter.Gen_Clusters_Base.Logging;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Logging);

package Nomo.Interpreter.Landmarks_Clusters.Logging is

   use Logging_Flags;

   procedure Log (This       : in Landmarks_Cluster;
                  Buffer_Ptr : not null access Storages.Full_Rule_Storage;
                  Flag       : in Log_Flag);

private

   use Landmark_Rules.Logging;

   package Landmarks_Clusters_Logging is new Landmarks_Clusters_Base.Logging (Landmarks_Cluster,
                                                                              Log_Partial,
                                                                              Log_Full);

   procedure Log (This       : in Landmarks_Cluster;
                  Buffer_Ptr : not null access Storages.Full_Rule_Storage;
                  Flag       : in Log_Flag) renames Landmarks_Clusters_Logging.Log;

end Nomo.Interpreter.Landmarks_Clusters.Logging;
