--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Numerics.Times;

with Nomo.Internal_Messages;

with Nomo.Interpreter.Premises_Index.Arrays;

with Nomo.Interpreter.Premises_Index.Focus;

with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

private with Nomo.Interpreter.Internal_Events_Index.Arrays;

package Nomo.Interpreter.Internal_Events_Index.Registers is

   use Numerics.Reals;
   use Premises_Index.Arrays;
   use Premises_Index.Focus;
   use Internal_Messages;

   type Internal_Register is tagged limited private;

   procedure Discern_Exciting_Evidences (This           : in Internal_Register;
                                         Matchmaker     : not null access Matchmakers.Matchmaker;
                                         Propositions   : not null access Internal_Premises;
                                         Designation    : in Premises_Focus;
                                         Distance       : out Positive_Real);

   procedure Discern_Exciting_Intentions (This           : in Internal_Register;
                                          Matchmaker     : not null access Matchmakers.Matchmaker;
                                          Propositions   : not null access Internal_Premises;
                                          Designation    : in Premises_Focus;
                                          Distance       : out Positive_Real);

   procedure Discern_Inhibiting_Intentions (This           : in Internal_Register;
                                            Matchmaker     : not null access Matchmakers.Matchmaker;
                                            Propositions   : not null access constant Internal_Premises;
                                            Designation    : in Premises_Focus;
                                            Score          : out Positive_Real);

   procedure Discern_Inhibiting_Evidences (This           : in Internal_Register;
                                           Matchmaker     : not null access Matchmakers.Matchmaker;
                                           Propositions   : not null access constant Internal_Premises;
                                           Designation    : in Premises_Focus;
                                           Score          : out Positive_Real);

   use Numerics.Times;

   procedure Put_Event (This         : in out Internal_Register;
                        Content      : in Internal_Message;
                        Arrival_Time : in Positive_Time);

   procedure Update (This : in out Internal_Register;
                     T    : in Positive_Time);

private

   use Internal_Events_Index.Arrays;

   type Internal_Register is tagged limited record
      Current_Evidence      : Internal_Event_Index := Internal_Event_Index'Last;
      Evidences_Number      : Natural range 0 .. Natural (Internal_Event_Index'Last) := 0;
      Forked_Evidences      : Boolean := True;
      Forked_Intentions     : Boolean := False;
      Intentions_Number     : Natural range 0 .. Natural (Internal_Event_Index'Last) := 0;
      Last_Intention        : Internal_Event_Index := Internal_Event_Index'Last;
      Most_Ancient_Evidence : Internal_Event_Index := Internal_Event_Index'First;
      Trace                 : Internal_Events_Array;
   end record;

end Nomo.Interpreter.Internal_Events_Index.Registers;
