--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;
use Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;
use Nomo.Numerics.Reals;

generic
   with procedure Adjust (This            : in out Rule;
                          Specificity_Log : in out Real_Accurately);
   with procedure Evaluate (This  : in out Rule;
                            Score : out Positive_Real);
   with procedure Evaluate (This  : in out Rule;
                            Shift : in Real_Accurately;
                            Score : out Positive_Real);
   with function Is_Updatable (This : in Rule) return Boolean;
   with function Is_Forget (This : in Rule) return Boolean;
   with procedure Update_Relevance (This : in out Rule);
   with procedure Update_Relevance (This       : in out Rule;
                                    Scores_Sum : in Strictly_Positive_Real);
package Nomo.Interpreter.Gen_Rules_Directories.Standard is

   pragma Pure;

   type Standard_Directory is new Rules_Directory with private;

   procedure Interpret (This          : in out Standard_Directory;
                        Selected_Rule : out Rule_Ptr);

   procedure Update_Relevance (This : in out Standard_Directory);

private

   type Standard_Directory is new Rules_Directory with null record;

end Nomo.Interpreter.Gen_Rules_Directories.Standard;
