--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Gen_Rules_Directories.Linking is

   procedure Initialize_Links (This   : in Rules_Directory;
                               Target : in Linked_Cluster) is
      References : Rule_References renames This.References;
   begin
      for I in reverse Reference_Index'First .. This.Last_Reference loop
         declare
            R : Rule renames References(I).Reference.all;
         begin
            Set_Linked_Rule (R, Get_Link (Target, Get_Conclusion_Information (R)));
         end;
      end loop;
   end Initialize_Links;

end Nomo.Interpreter.Gen_Rules_Directories.Linking;
