--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Gen_Clusters_Base is

   function Get_Selected_Rule (This : in Cluster_Base) return not null Rule_Ptr is
   begin
      return This.Selected_Rule;
   end Get_Selected_Rule;

   function Has_Selection (This : in Cluster_Base) return Boolean is
   begin
      return This.Selected_Rule /= null;
   end Has_Selection;

   procedure Interpret (This : in out Cluster_Base) is
   begin
      Local_Standard_Directories.Interpret (This.Directory, This.Selected_Rule);
   end Interpret;

   procedure Update_Relevance (This : in out Cluster_Base) is
   begin
      Local_Standard_Directories.Update_Relevance (This.Directory);
      This.Selected_Rule := null;
   end Update_Relevance;

end Nomo.Interpreter.Gen_Clusters_Base;
