--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;
use Nomo.Numerics.Informations;

with Nomo.Interpreter.Storages;
use Nomo.Interpreter.Storages;

with Nomo.Interpreter.Types_Index.Ranges;
use Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Gen_Rules_Directories.Insertion;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Insertion);

generic
   with procedure Initialize (This                       : out Rule;
                              Rule_Storage               : in Full_Rule_Storage;
                              Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                              Excitatory_Specificity_Log : out Real_Accurately;
                              Inhibitory_Specificity_Log : out Real_Accurately;
                              Input_Type                 : in Input_Type_Index);
   with function Is_Equal (This        : in Rule;
                           Information : in Positive_Integer) return Boolean;
package Nomo.Interpreter.Gen_Clusters_Base.Perceptive_Loading is

   function Has_Space (This : in Cluster_Base) return Boolean;

   procedure Load (This       : in out Cluster_Base;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage;
                   Input_Type       : in Input_Type_Index);

   function Get_Perception (This        : in Cluster_Base;
                            Information : in Positive_Integer) return Rule_Ptr;
   pragma Inline(Get_Perception);

private

   package Local_Insertion is new Local_Rules_Directories.Insertion (Is_Updatable);

end Nomo.Interpreter.Gen_Clusters_Base.Perceptive_Loading;
