--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;
use Nomo.Numerics.Informations;

with Nomo.Interpreter.Storages;
use Nomo.Interpreter.Storages;

with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

private with Nomo.Interpreter.Gen_Rules_Directories.Insertion;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Insertion);

generic
   with procedure Initialize (This                       : out Rule;
                              Rule_Storage               : in Full_Rule_Storage;
                              Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                              Excitatory_Specificity_Log : out Real_Accurately;
                              Inhibitory_Specificity_Log : out Real_Accurately);
   with function Get_Perception_Information (This : in Rule) return Positive_Integer;
   type Perceptions_Cluster is limited private;
   type Perceptive_Rule is limited private;
   with function Get_Perception (This        : in Perceptions_Cluster;
                                 Information : in Positive_Integer) return access Perceptive_Rule;
   with procedure Set_Linked_Perception (This              : out Rule;
                                         Linked_Perception : access Perceptive_Rule);
package Nomo.Interpreter.Gen_Clusters_Base.Commanding_Loading is

   procedure Initialize_Links (This   : in out Cluster_Base;
                               Target : in Perceptions_Cluster);

   function Has_Space (This : in Cluster_Base) return Boolean;

   procedure Load (This             : in out Cluster_Base;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage;
                   Last_Loaded      : out Rule_Ptr);

private

   package Local_Insertion is new Local_Rules_Directories.Insertion (Is_Updatable);

end Nomo.Interpreter.Gen_Clusters_Base.Commanding_Loading;
