--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.External_Messages;

with Nomo.Interpreter.External_Events_Index;

with Nomo.Interpreter.Components_Index;

package Nomo.Interpreter.Event_Memory.External.Plant is

   use Numerics.Times;
   use Types_Index.Ranges;
   use External_Messages;
   use External_Events_Index;
   use Components_Index;

   procedure Get_Current_Event (Scope_Index  : in Positive;
                                I            : out Input_Type_Index;
                                Arrival_Time : out Positive_Time;
                                Position     : out External_Event_Index);
   pragma Inline (Get_Current_Event);

   procedure Get_Event (I              : in Input_Type_Index;
                        Arrival_Time   : in out Positive_Time;
                        Sensitive_Data : out External_Message;
                        Size           : in Component_Index);
   pragma Inline (Get_Event);

   procedure Get_Event (I              : in Input_Type_Index;
                        Position       : in External_Event_Index;
                        Sensitive_Data : out External_Message;
                        Size           : in Component_Index);
   pragma Inline (Get_Event);

end Nomo.Interpreter.Event_Memory.External.Plant;
