--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with System;

with Nomo.Numerics.Reals;

package Nomo.Interpreter.Emission_Channels is

   pragma Pure;

   Priority_Emission : constant Positive := 17;

   use Numerics.Reals;

   type Callback is access procedure (Intensity : in Real_0_To_1;
                                      Data      : in System.Address);
   pragma Convention (C, Callback);

   protected type Emission_Channel is

      pragma Priority (Priority_Emission);

      procedure Initialize (Action : in not null Callback);

      procedure Put (Intensity : in Real_0_To_1;
                     Data      : in System.Address);
      pragma Precondition(System."/=" (System.Null_Address, Data));

   private

      Output : Callback := null;

   end Emission_Channel;

end Nomo.Interpreter.Emission_Channels;
