--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Premises_Index.Arrays.Checking;

package body Nomo.Interpreter.Conditions_Base.Checking_Initialization is

   procedure Initialize_Bonus (This     : in out Condition_Base;
                               Landmark : in Premise_Index;
                               Bonus    : out Positive_Time_Interval) is
      use Premises_Index.Arrays.Checking;
      Time_Span : Positive_Time_Interval;
   begin
      Get_New_Time_Span (This.Premises, Landmark, Time_Span, Bonus);
      pragma Unreferenced(Time_Span);
   end Initialize_Bonus;

end Nomo.Interpreter.Conditions_Base.Checking_Initialization;
