--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading);

with Nomo.Interpreter.Gen_Clusters_Base.Initialization;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Initialization);

with Nomo.Interpreter.Conception_Rules.Initialization;

package body Nomo.Interpreter.Conceptions_Clusters.Loading is

   package Local_Initialization is new Conceptions_Clusters_Base.Initialization;

   procedure Initialize (This            : in out Conceptions_Cluster;
                         Conception_Type : in Conception_Type_Index) is
      use Local_Initialization;
   begin
      This.Conception_Type := Conception_Type;
      Initialize (Cluster_Base (This));
   end Initialize;

   use Conception_Rules.Initialization;

   package Local_Loading is new Conceptions_Clusters_Base.Standard_Loading (Initialize);

   function Has_Space (This : in Conceptions_Cluster) return Boolean is
   begin
      return Local_Loading.Has_Space (Cluster_Base (This));
   end Has_Space;

   procedure Load (This             : in out Conceptions_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) is
      use Local_Loading;
   begin
      Load (Cluster_Base (This), Rule_Storage_Ptr);
   end Load;

end Nomo.Interpreter.Conceptions_Clusters.Loading;
