--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Times;

private with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

private with Nomo.Interpreter.Activations_Memories;
pragma Elaborate_All (Nomo.Interpreter.Activations_Memories);

private with Nomo.Interpreter.Gen_Clusters_Base;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base);

private with Nomo.Interpreter.Command_Rules;

private with Nomo.Interpreter.Emission_Channels;

private package Nomo.Interpreter.Commands_Clusters is

   use Numerics.Accurately;
   use Numerics.Times;

   type Commands_Cluster is tagged limited private;

   procedure Assume (This : in out Commands_Cluster;
                     T    : in Positive_Time);

   function Has_Selection (This : in Commands_Cluster) return Boolean;
   pragma Inline (Has_Selection);

   procedure Interpret (This : in out Commands_Cluster);
   pragma Inline (Interpret);

   procedure Reinforce (This            : in out Commands_Cluster;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);
   pragma Inline (Reinforce);

private

   use Types_Index.Ranges;
   use Command_Rules;

   type Command_Rule_Ptr is access all Command_Rule;

   package Commands_Clusters_Base is new Gen_Clusters_Base (Command_Rule,
                                                            Command_Rule_Ptr,
                                                            Beginning.Parameters.Get_Maximum_Of_Rules_By_Type,
                                                            Adjust,
                                                            Evaluate,
                                                            Evaluate,
                                                            Is_Forget,
                                                            Is_Updatable,
                                                            Update_Relevance,
                                                            Update_Relevance);
   use Commands_Clusters_Base;

   package Activations_Actions_Memories is new Activations_Memories (Command_Rule,
                                                                     Command_Rule_Ptr,
                                                                     Reinforce);
   use Activations_Actions_Memories;

   use Emission_Channels;

   type Commands_Cluster is new Cluster_Base with record
      Activations  : Activations_Memory;
      Command_Type : Command_Type_Index;
      Action       : Emission_Channel;
      Last_Loaded  : Command_Rule_Ptr;
   end record;

end Nomo.Interpreter.Commands_Clusters;
