--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

with Nomo.Interpreter.Perceptions_Clusters;

with Nomo.Interpreter.Types_Index.Ranges;

package Nomo.Interpreter.Commands_Clusters.Loading is

   use Types_Index.Ranges;
   use Perceptions_Clusters;

   function Has_Space (This : in Commands_Cluster) return Boolean;

   procedure Initialize (This         : in out Commands_Cluster;
                         Command_Type : in Command_Type_Index);

   procedure Initialize_Links (This   : in out Commands_Cluster;
                               Target : in Perceptions_Cluster);
   pragma Inline (Initialize_Links);

   procedure Load (This             : in out Commands_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);
   pragma Inline (Load);

   procedure Update_Last_Link (This   : in out Commands_Cluster;
                               Target : in out Perceptions_Cluster);

end Nomo.Interpreter.Commands_Clusters.Loading;
