--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

with Nomo.Interpreter.Predictions_Clusters;

with Nomo.Interpreter.Types_Index.Ranges;

package Nomo.Interpreter.Checks_Clusters.Loading is

   use Types_Index.Ranges;

   procedure Initialize (This       : in out Checks_Cluster;
                         Check_Type : in Check_Type_Index);

   use Predictions_Clusters;

   procedure Initialize_Links (This   : in out Checks_Cluster;
                               Target : in Predictions_Cluster);

   function Has_Space (This : in Checks_Cluster) return Boolean;

   procedure Load (This             : in out Checks_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);

   procedure Update_Last_Link (This   : in out Checks_Cluster;
                               Target : in out Predictions_Cluster);

end Nomo.Interpreter.Checks_Clusters.Loading;
