--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages;

with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Rules_Base.Delayed;

private with Nomo.Internal_Messages.Conclusions.Instantaneous;

private with Nomo.Interpreter.Check_Conditions;

private with Nomo.Internal_Messages.Conclusions.Delayed.Predictive;

private with Nomo.Numerics.Reals;

private package Nomo.Interpreter.Check_Rules is

   type Check_Rule is tagged limited private;

   procedure Add_Score (This : in out Check_Rule);

   procedure Adjust (This : in out Check_Rule);

   procedure Evaluate (This : in out Check_Rule);
   --  Evalue la rgle en fonction de l'tat courant de la mmoire
   --  vnementielle, autrement-dit c'est une valuation ponctuelle dans
   --  le cadre de l'valuation global de la prdiction.

   function Get_Conclusion (This : in Check_Rule) return not null access constant Internal_Messages.Internal_Message;

   function Is_Ongoing (This : in Check_Rule) return Boolean;
   --  Renvoie vrai si la prdiction est toujours en cours d'valuations.
   --  Autrement-dit s'il y a une prdiction sous forme intentionnel dans
   --  la mmoire vnementielle dont l'information est gal  celle de
   --  la prmisse.

   function Is_Forget (This : in Check_Rule) return Boolean;
   pragma Inline(Is_Forget);

   function Is_Updatable (This : in Check_Rule) return Boolean;
   pragma Inline(Is_Updatable);

   procedure Update_Relevance (This : in out Check_Rule);

   use Types_Index.Ranges;

   function Are_Eligible (Precitive_Link : in Prediction_Type_Index) return Boolean;

private

   use Rules_Base.Delayed;
   use Internal_Messages.Conclusions.Instantaneous;
   use Internal_Messages.Conclusions.Delayed.Predictive;
   use Check_Conditions;
   use Numerics.Reals;

   type Check_Rule is new Delayed_Rule with record
      Conclusion        : aliased Instantaneous_Conclusion;
      Condition         : Check_Condition;
      Credibility_Max   : Positive_Real := 0.0;
      Linked_Prediction : access Predictive_Conclusion;
   end record;

end Nomo.Interpreter.Check_Rules;
