--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Directories;

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;

with Nomo.Numerics.Fitting;

with Nomo.Numerics.Times;

private with Nomo.Reader.Parameters;
pragma Elaborate_All (Nomo.Reader.Parameters);

package Nomo.Interpreter.Beginning.Parameters is

   use Numerics.Accurately;

   use Numerics.Reals;

   function Get_Check_Cover return Positive_Real;

   function Get_Bid_Rate return Real_Accurately_0_To_1;

   function Get_Tax_Rate return Real_Accurately_0_To_1;

   function Get_Reimbursement_Rate return Real_Accurately_0_To_1;

   function Get_Reward_Rate return Real_Accurately_0_To_1;

   function Get_Forget return Real_Accurately_0_To_1;

   function Get_Maximum_Of_Components return Positive;

   function Get_Maximum_Of_External_Events return Positive;

   function Get_Maximum_Of_Internal_Events return Positive;

   function Get_Maximum_Of_Premises return Positive;

   function Get_Maximum_Of_Rules_By_Type return Positive;

   use Numerics.Fitting;

   function Get_Maximum_Of_Maximizations return Count;

   use Numerics.Times;

   function Get_Time_Span_Limit return Positive_Time_Interval;

   function Get_Period return Positive_Time;
   pragma Postcondition (Get_Period'Result > 0);

   use Types_Directories;

   function Get_Types_Directory return Types_Directories_Instance.Types_Directory;

private

   function Get_Check_Cover return Positive_Real renames Reader.Parameters.Get_Check_Cover;

   function Get_Bid_Rate return Real_Accurately_0_To_1 renames Reader.Parameters.Get_Bid_Rate;

   function Get_Tax_Rate return Real_Accurately_0_To_1 renames Reader.Parameters.Get_Tax_Rate;

   function Get_Reimbursement_Rate return Real_Accurately_0_To_1 renames Reader.Parameters.Get_Reimbursement_Rate;

   function Get_Reward_Rate return Real_Accurately_0_To_1 renames Reader.Parameters.Get_Reward_Rate;

   function Get_Forget return Real_Accurately_0_To_1 renames Reader.Parameters.Get_Forget;

   function Get_Maximum_Of_Components return Positive renames Reader.Parameters.Get_Maximum_Of_Components;

   function Get_Maximum_Of_External_Events return Positive renames Reader.Parameters.Get_Maximum_Of_External_Events;

   function Get_Maximum_Of_Internal_Events return Positive renames Reader.Parameters.Get_Maximum_Of_Internal_Events;

   function Get_Maximum_Of_Premises return Positive renames Reader.Parameters.Get_Maximum_Of_Premises;

   function Get_Maximum_Of_Rules_By_Type return Positive renames Reader.Parameters.Get_Maximum_Of_Rules_By_Type;

   function Get_Maximum_Of_Maximizations return Count renames Reader.Parameters.Get_Maximum_Of_Maximizations;

   function Get_Time_Span_Limit return Positive_Time_Interval renames Reader.Parameters.Get_Time_Span_Limit;

   function Get_Period return Positive_Time renames Reader.Parameters.Get_Period;

   function Locale_Get_Types_Directory is new Reader.Parameters.Get_Types_Directory (Types_Directories_Instance);

   function Get_Types_Directory return Types_Directories_Instance.Types_Directory renames Locale_Get_Types_Directory;

end Nomo.Interpreter.Beginning.Parameters;
