--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Gen_Time_Log_Header.Writing is

   Is_Initialized : Boolean := False;

   procedure Initialize (Maximum_Of_Premises   : in Natural;
                         Maximum_Of_Components : in Natural) is
   begin
      pragma Assert (not Is_Initialized);
      Premises_Maximum := Maximum_Of_Premises;
      Components_Maximum := Maximum_Of_Components;
      for I in Dictionary'Range loop
         Dictionary (I) := Get_Category (I);
      end loop;
      Is_Initialized := True;
   end Initialize;

   procedure Write (Stream : in not null Ada.Streams.Stream_IO.Stream_Access) is
   begin
      pragma Assert (Is_Initialized);
      Type_Index'Write (Stream, Internal_Type_Index'First - 1);
      Internal_Type_Index'Write (Stream, Internal_Type_Index'Last);
      Natural'Write (Stream, Premises_Maximum);
      Natural'Write (Stream, Components_Maximum);
      for I in Dictionary'Range loop
         Type_Category'Write (Stream, Dictionary (I));
      end loop;
   end Write;

end Nomo.Gen_Time_Log_Header.Writing;
