--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Gen_Types_Index;

with Nomo.Gen_Types_Directories;

with Nomo.Gen_Components_Index;

with Nomo.Gen_Premises_Index;

with Nomo.Gen_Integrations_Arrays;

with Nomo.Gen_External_Messages.Premises;

with Nomo.Gen_External_Messages;

with Nomo.Gen_Premises_Index.Arrays;

with Nomo.Gen_Rule_Storages;

private generic
   with  package Types_Index is new Gen_Types_Index (<>);
   use Types_Index;
   Maximum_Of_Premises   : Natural;
   Maximum_Of_Components : Natural;
   Number_Of_Input_Types : Type_Index;
package Nomo.Gen_Factory is

   subtype Internal_Type_Index is Type_Index range Number_Of_Input_Types + 1 .. Type_Index'Last;

   subtype External_Type_Index is Type_Index range Types_Index.Type_Index_Strict'First .. Number_Of_Input_Types;

   package Types_Directories is new Gen_Types_Directories (Types_Index);

   package Components_Index is new Gen_Components_Index (Maximum_Of_Components);
   use Components_Index;

   package Premises_Index is new Gen_Premises_Index (Maximum_Of_Premises);
   use Premises_Index;

   package Premises_Index_Arrays is new Premises_Index.Arrays (Internal_Type_Index);

   package Integrations_Arrays is new Gen_Integrations_Arrays (Components_Index.Component_Index);

   package External_Messages is new Gen_External_Messages (Components_Index.Component_Index);

   type Local_External_Message is new External_Messages.External_Message;

   package External_Messages_Premises is new External_Messages.Premises (Local_External_Message,
                                                                         Integrations_Arrays);

   package Rule_Storages is new Gen_Rule_Storages (Premises_Index.Premise_Index,
                                                   Internal_Type_Index,
                                                   External_Type_Index,
                                                   Component_Index,
                                                   Premises_Index_Arrays.Internal_Premises,
                                                   Premises_Index_Arrays.Internal_Premises_Types,
                                                   Premises_Index_Arrays.Internal_Premises_Properties,
                                                   External_Messages.External_Message,
                                                   External_Messages_Premises.External_Premise);

end Nomo.Gen_Factory;
