--  Copyright (2008-2014) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Text_IO;
with Ada.Integer_Text_IO;

with Ada.Directories;

with Ada.Exceptions;

with System;

with Interfaces.C.Strings;

with Nomo.Numerics.Reals;

with Nomo.Generator;

procedure NomoGenerator is

   Item        : String (1..256);
   Last        : Integer;

   procedure Error (Message : in String);

   procedure Error (Message : in String) is
      use Ada.Text_IO;
      File_Name : constant String := "nomogenerator.err";
      Error_File : File_Type;
   begin
      if Ada.Directories.Exists (File_Name) then
         Open (Error_File , Append_File, File_Name);
      else
         Create (Error_File , Append_File, File_Name);
      end if;
      Put_Line (Error_File, Message);
      Close(Error_File);
   end Error;

   type Callback is access procedure (Intensity : in Nomo.Numerics.Reals.Real_0_To_1;
                                      Data      : in System.Address);
   pragma Convention (C, Callback);
   type Callbacks is array (Natural Range <>) of Callback;
   pragma Convention (C, Callbacks);

    procedure Command_Null (Intensity : in Nomo.Numerics.Reals.Real_0_To_1; Data : in System.Address);
    pragma Convention (C, Command_Null);

   procedure Command_Null (Intensity : in Nomo.Numerics.Reals.Real_0_To_1; Data : in System.Address) is
   begin
      null;
   end Command_Null;

   Actions : constant Callbacks (1..1) := (1 => Command_Null'Access);

begin

   Nomo.Generator.Generate ("");

exception
   when Event : others =>
      Error (Ada.Exceptions.Exception_Information (Event));
end NomoGenerator;
