--  Copyright (2008-2014) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Integer_Text_IO;
use Ada.Integer_Text_IO;

package body Nomo.Interpreter.Epistemic_Memory.Gen_Section.Generator is

   use Ada.Text_IO;

   Base      : constant Natural := 16;
   Size_Line : constant Natural := 100;

   procedure Put (F : in File_Type) is
      type Cluster_Bytes is array (1 .. Cluster'Size / Short_Short_Integer'Size) of Short_Short_Integer;
      This_Bytes : array (1 .. This'Length) of Cluster_Bytes;
      for This_Bytes'Address use This'Address;
      Name_Type_Cluster : constant String := Name & "_Cluster_Bytes";
   begin
      if This'Size /= 0 then
         Put_Line (F, "   type " & Name_Type_Cluster & " is array (" & Natural'Image(Cluster_Bytes'First) & " .." & Natural'Image(Cluster_Bytes'Last ) & ") of Short_Short_Integer;" );
         Put (F, "   " & Name & "_Epistemic_Memory_Bytes : array (" & Natural'Image(This_Bytes'First) & " .." & Natural'Image(This_Bytes'Last) & ") of " & Name_Type_Cluster & " := (" );
         if This_Bytes'Last = 1 then
            Put_Line (F, " 1 =>");
         else
            New_line (F);
         end if;
         for I in This_Bytes'First .. This_Bytes'Last - 1 loop
            Put (F, "   (");
            for J in Cluster_Bytes'First .. Cluster_Bytes'Last - 1 loop
               Put (F, Integer (This_Bytes(I)(J)), 0, Base);
               Put (F, ",");
               if ((I - 1) * Size_Line  + J) mod Size_Line = 0 then
                New_Line (F);
                Put (F, "   ");
               end if;
            end loop;
            Put (F, Integer (This_Bytes(I)(Cluster_Bytes'Last)), 0, Base);
            Put_Line (F, "),");
         end loop;
         Put (F, "   (");
         for J in Cluster_Bytes'First .. Cluster_Bytes'Last - 1 loop
            Put (F, Integer (This_Bytes(This_Bytes'Last)(J)), 0, Base);
            Put (F, ",");
            if ((This_Bytes'Last - 1) * Size_Line  + J) mod Size_Line  = 0 then
                New_Line (F);
                Put (F, "   ");
             end if;
         end loop;
         Put (F, Integer (This_Bytes(This_Bytes'Last)(Cluster_Bytes'Last)), 0, Base);
         Put_Line (F, ")");
         Put_Line (F, "   );");
         New_Line (F);
         Put(Cluster_Bytes'Size);
         Put(This_Bytes'Size);
         Put(Cluster_Bytes'Size * This_Bytes'Length);
      end if;
   end Put;

end Nomo.Interpreter.Epistemic_Memory.Gen_Section.Generator;
