--  Copyright (2008-2014) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Text_IO;
use Ada.Text_IO;

with Nomo.Interpreter.Epistemic_Memory.Interpretation;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Interpretation);

with Nomo.Interpreter.Epistemic_Memory.Checking.Generator;

with Nomo.Interpreter.Epistemic_Memory.Perceptive.Generator;

with Nomo.Interpreter.Epistemic_Memory.Conceptive.Generator;

with Nomo.Interpreter.Epistemic_Memory.Landmarking.Generator;

with Nomo.Interpreter.Epistemic_Memory.Commanding.Generator;

with Nomo.Interpreter.Epistemic_Memory.Predictive.Generator;

with Nomo.Interpreter.Epistemic_Memory.Reflective.Generator;

package body Nomo.Interpreter.Epistemic_Memory.Generator is

   procedure Generate (Path : String) is

      F : File_Type;

   begin

      Create (F, Out_File, Path & "nomo-epistemic_memory-binaries.ads");
      Put_Line (F, "private package Nomo.Epistemic_Memory.Binaries is");
      New_Line (F);
      Checking.Generator.Put (F);
      Perceptive.Generator.Put (F);
      Conceptive.Generator.Put (F);
      Landmarking.Generator.Put (F);
      Commanding.Generator.Put (F);
      Predictive.Generator.Put (F);
      Reflective.Generator.Put (F);
      Put (F, "end Nomo.Epistemic_Memory.Binaries;");

   end Generate;

end Nomo.Interpreter.Epistemic_Memory.Generator;
