//  Copyright (2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef NOMOWORLDSQUARE_H
#define NOMOWORLDSQUARE_H

/* Interface for nomoInterpreter created with nomoSDK */

#include "nomointerpreter.h"

/* ID of input types */
#define INPUT_HUE_WORLDSQUARE_ID 1  // program: agent model: worldsquare
#define INPUT_SPHERES_NUMBER_WORLDSQUARE_ID 2  // program: agent model: worldsquare
#define INPUT_STRENGTH_WORLDSQUARE_ID 3  // program: agent model: worldsquare
#define INPUT_RANDOM_WORLDSQUARE_ID 4  // program: agent model: worldsquare
#define INPUT_SOUND_WORLDSQUARE_ID 5  // program: agent model: worldsquare
#define INPUT_SONAR_WORLDSQUARE_ID 6  // program: agent model: worldsquare
#define INPUT_BUMPER_WORLDSQUARE_ID 7  // program: agent model: worldsquare

/* Size of inputs and commands */
#define INPUT_HUE_WORLDSQUARE_SIZE 1
#define INPUT_SPHERES_NUMBER_WORLDSQUARE_SIZE 1
#define INPUT_STRENGTH_WORLDSQUARE_SIZE 1
#define INPUT_RANDOM_WORLDSQUARE_SIZE 1
#define INPUT_SOUND_WORLDSQUARE_SIZE 1
#define INPUT_SONAR_WORLDSQUARE_SIZE 4
#define INPUT_BUMPER_WORLDSQUARE_SIZE 4
#define COMMAND_MOTOR_WORLDSQUARE_SIZE 2
#define COMMAND_SOUND_WORLDSQUARE_SIZE 2

/* Components of inputs and components of commands with demultiplexing value */
typedef enum {INPUT_HUE_WORLDSQUARE_VALUE = 0} inputHueWorldsquareAgentComponent;
typedef enum {INPUT_SPHERES_NUMBER_WORLDSQUARE_VALUE = 0} inputSpheresNumberWorldsquareAgentComponent;
typedef enum {INPUT_STRENGTH_WORLDSQUARE_VALUE = 0} inputStrengthWorldsquareAgentComponent;
typedef enum {INPUT_RANDOM_WORLDSQUARE_VALUE = 0} inputRandomWorldsquareAgentComponent;

typedef enum {INPUT_SOUND_WORLDSQUARE_VALUE = 0} inputSoundWorldsquareAgentComponent;
typedef enum {INPUT_SONAR_WORLDSQUARE_LEFT = 0, INPUT_SONAR_WORLDSQUARE_FRONT = 1, INPUT_SONAR_WORLDSQUARE_RIGHT = 2, INPUT_SONAR_WORLDSQUARE_BACK = 3} inputSonarWorldsquareAgentComponent;
typedef enum {INPUT_BUMPER_WORLDSQUARE_LEFT = 0, INPUT_BUMPER_WORLDSQUARE_FRONT = 1, INPUT_BUMPER_WORLDSQUARE_RIGHT = 2, INPUT_BUMPER_WORLDSQUARE_BACK = 3} inputBumperWorldsquareAgentComponent;

typedef enum {COMMAND_MOTOR_WORLDSQUARE_VALUE = 0, COMMAND_MOTOR_WORLDSQUARE = 1} commandMotorWorldsquareAgentComponent;
typedef enum {COMMAND_SOUND_WORLDSQUARE_VALUE = 0, COMMAND_SOUND_WORLDSQUARE = 1} commandSoundWorldsquareAgentComponent;

/* Command functions with demultiplexing */
void commandMotorWorldsquare(const float intensity, const float * data);
void commandSoundWorldsquare(const float intensity, const float * data);

#define CALLBACKS_NUMBER 2

const static nomoCallback nomoActions [CALLBACKS_NUMBER] = {
commandMotorWorldsquare,
commandSoundWorldsquare
};

/* ID of log types */
// program: agent model: worldsquare
#define COMMAND_MOTOR_WORLDSQUARE_LOG 0
// program: agent model: worldsquare
#define COMMAND_SOUND_WORLDSQUARE_LOG 1
// program: agent model: worldsquare
#define PERCEPTION_HUE_WORLDSQUARE_LOG 2
// program: agent model: worldsquare
#define PERCEPTION_SPHERES_NUMBER_WORLDSQUARE_LOG 3
// program: agent model: worldsquare
#define PERCEPTION_STRENGTH_WORLDSQUARE_LOG 4
// program: agent model: worldsquare
#define PERCEPTION_RANDOM_WORLDSQUARE_LOG 5
// program: agent model: worldsquare
#define PERCEPTION_SOUND_WORLDSQUARE_LOG 6
// program: agent model: worldsquare
#define PERCEPTION_SONAR_WORLDSQUARE_LOG 7
// program: agent model: worldsquare
#define PERCEPTION_BUMPER_WORLDSQUARE_LOG 8

#define TYPES_LOG_NUMBER 9

#endif // NOMOWORLDSQUARE_H

