--  Copyright (2008-2011) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Basic_Sax is

   function Get_Quantity (A : in Attributes) return Natural is
   begin
      return A.Size;
   end Get_Quantity;

   function Get_Name (A     : in Attributes;
                      Index : in Positive) return String is
   begin
      if Index > A.Size then
         raise NULL_ATTRIBUTE;
      else
         return Ada.Strings.Unbounded.To_String (A.Tab (Index).Name);
      end if;
   end Get_Name;

   function Get_Value (A     : in Attributes;
                       Index : in Positive) return String is
   begin
      if Index > A.Size then
         raise NULL_ATTRIBUTE;
      else
         return Ada.Strings.Unbounded.To_String (A.Tab (Index).Value);
      end if;
   end Get_Value;

end Basic_Sax;
