<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:code="http://www.nomoseed.org/code">
  <xsl:output method="xml" indent="yes" encoding="utf-8"/>
  <xsl:param name="name" select="'test'"/>
  <xsl:param name="option" select="''"/>
  <xsl:variable name="maximum_of_rules_by_type">
    <xsl:choose>
      <xsl:when test="$option='full'">
        <xsl:value-of select="/code:code/code:knowledge_base/code:maximum_of_rules_by_type/@value"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="number_of_rules" select="/code:code/code:proportions/@number_of_rules"/>
        <xsl:variable name="number_of_types" select="/code:code/code:proportions/@number_of_types"/>
        <xsl:value-of select="round($number_of_rules div $number_of_types)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="maximum_of_components">
    <xsl:choose>
      <xsl:when test="$option='full'">
        <xsl:value-of select="/code:code/code:proportions/@maximum_of_components"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="sum_of_components" select="count(/code:code/code:types/code:type/code:component)"/>
        <xsl:variable name="sum_of_inputs" select="count(/code:code/code:types/code:type[@category='input'])"/>
        <xsl:value-of select="round($sum_of_components div $sum_of_inputs)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="maximum_of_maximizations" select="/code:code/code:knowledge_base/code:maximum_of_maximizations/@value"/>
  <xsl:variable name="tolerance_timespan">
    <xsl:choose>
      <xsl:when test="//code:timespan[@tolerance != 'INF' and @tolerance != 0]">
        <xsl:value-of select="2"/>
      </xsl:when>
      <xsl:when test="//code:timespan[@tolerance != 'INF']">
        <xsl:value-of select="0"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'INF'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="tolerance_credibility">
    <xsl:choose>
      <xsl:when test="//code:credibility[@tolerance != 'INF' and @tolerance != 0]">
        <xsl:value-of select="1"/>
      </xsl:when>
      <xsl:when test="//code:credibility[@tolerance != 'INF']">
        <xsl:value-of select="0"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'INF'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="relevance">
    <xsl:choose>
      <xsl:when test="//code:rule[@relevance != 1 and @relevance != 0]">
        <xsl:value-of select="0.99"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="1"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="fitting_nbr">
    <xsl:choose>
      <xsl:when test="//code:rule[@fitting_nbr != 'INF' and @fitting_nbr &lt; $maximum_of_maximizations]">
        <xsl:value-of select="0.99"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'INF'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="maximum_of_internal_events" select="/code:code/code:knowledge_base/code:maximum_of_internal_events/@value"/>
  <xsl:variable name="maximum_of_premises" select="/code:code/code:knowledge_base/code:maximum_of_premises/@value"/>
  <xsl:variable name="sequence_nbr" select="floor($maximum_of_premises div $maximum_of_internal_events)"/>
  <xsl:variable name="remainder" select="$maximum_of_premises mod $maximum_of_internal_events"/>
  <xsl:variable name="perception_sequence_nbr" select="floor(($maximum_of_premises - 1) div $maximum_of_internal_events)"/>
  <xsl:variable name="perception_remainder" select="($maximum_of_premises - 1) mod $maximum_of_internal_events"/>
  <xsl:template match="/code:code">
    <xsl:element name="unit" namespace="http://www.nomoseed.org/unit">
      <xsl:attribute name="name">
        <xsl:value-of select="$name"/>
      </xsl:attribute>
      <xsl:attribute name="multiplexer">
        <xsl:value-of select="'no'"/>
      </xsl:attribute>
      <xsl:attribute name="binaryLocation">
        <xsl:value-of select="''"/>
      </xsl:attribute>
      <xsl:element name="inference_engine" namespace="http://www.nomoseed.org/inference_engine">
        <xsl:attribute name="name">
          <xsl:value-of select="'test'"/>
        </xsl:attribute>
        <xsl:element name="frequency" namespace="http://www.nomoseed.org/inference_engine">
          <xsl:attribute name="value">
            <xsl:value-of select="1.0"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="forget" namespace="http://www.nomoseed.org/inference_engine">
          <xsl:attribute name="value">
            <xsl:value-of select="0.0"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="check_cover" namespace="http://www.nomoseed.org/inference_engine">
          <xsl:attribute name="value">
            <xsl:value-of select="1.0"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="bid_rate" namespace="http://www.nomoseed.org/inference_engine">
          <xsl:attribute name="value">
            <xsl:value-of select="0.001"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="reimbursement_rate" namespace="http://www.nomoseed.org/inference_engine">
          <xsl:attribute name="value">
            <xsl:value-of select="0.001"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="reward_rate" namespace="http://www.nomoseed.org/inference_engine">
          <xsl:attribute name="value">
            <xsl:value-of select="0.0"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="tax_rate" namespace="http://www.nomoseed.org/inference_engine">
          <xsl:attribute name="value">
            <xsl:value-of select="0.00001"/>
          </xsl:attribute>
        </xsl:element>
      </xsl:element>
      <xsl:element name="knowledge_base" namespace="http://www.nomoseed.org/knowledge_base">
        <xsl:attribute name="name">
          <xsl:value-of select="'test'"/>
        </xsl:attribute>
        <xsl:element name="time_span_limit" namespace="http://www.nomoseed.org/knowledge_base">
          <xsl:attribute name="value">
            <xsl:value-of select="code:knowledge_base/code:time_span_limit/@value"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="maximum_of_maximizations" namespace="http://www.nomoseed.org/knowledge_base">
          <xsl:attribute name="value">
            <xsl:value-of select="1000"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="maximum_of_internal_events" namespace="http://www.nomoseed.org/knowledge_base">
          <xsl:attribute name="value">
            <xsl:value-of select="$maximum_of_internal_events"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="maximum_of_external_events" namespace="http://www.nomoseed.org/knowledge_base">
          <xsl:attribute name="value">
            <xsl:value-of select="code:knowledge_base/code:maximum_of_external_events/@value"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="maximum_of_rules_by_type" namespace="http://www.nomoseed.org/knowledge_base">
          <xsl:attribute name="value">
            <xsl:value-of select="$maximum_of_rules_by_type + 1"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="maximum_of_premises" namespace="http://www.nomoseed.org/knowledge_base">
          <xsl:attribute name="value">
            <xsl:value-of select="$maximum_of_premises"/>
          </xsl:attribute>
        </xsl:element>
      </xsl:element>
      <xsl:variable name="conception_nbr" select="count(code:types/code:type[@category != 'perception' and @category != 'input'])"/>
      <xsl:variable name="perception_nbr" select="count(code:types/code:type[@category = 'perception'])"/>
      <xsl:element name="program" namespace="http://www.nomoseed.org/program">
        <xsl:attribute name="name">
          <xsl:value-of select="'test'"/>
        </xsl:attribute>
        <xsl:element name="body" namespace="http://www.nomoseed.org/program">
          <xsl:element name="models" namespace="http://www.nomoseed.org/program">
            <xsl:element name="new" namespace="http://www.nomoseed.org/program">
              <xsl:attribute name="instance">
                <xsl:value-of select="'test'"/>
              </xsl:attribute>
              <xsl:element name="model" namespace="http://www.nomoseed.org/model">
                <xsl:attribute name="name">
                  <xsl:value-of select="'test'"/>
                </xsl:attribute>
                  <xsl:element name="definition" namespace="http://www.nomoseed.org/model">
                    <xsl:element name="command_type" namespace="http://www.nomoseed.org/model">
                      <xsl:attribute name="name">
                        <xsl:value-of select="'time'"/>
                      </xsl:attribute>
                      <xsl:element name="items" namespace="http://www.nomoseed.org/model">
                        <xsl:element name="item" namespace="http://www.nomoseed.org/model">
                          <xsl:attribute name="name">
                            <xsl:value-of select="'time'"/>
                          </xsl:attribute>
                        </xsl:element>
                      </xsl:element>
                      <xsl:element name="components" namespace="http://www.nomoseed.org/model">
                        <xsl:element name="component" namespace="http://www.nomoseed.org/model">
                          <xsl:attribute name="name">
                            <xsl:value-of select="'value'"/>
                          </xsl:attribute>
                        </xsl:element>
                      </xsl:element>
                    </xsl:element>
                    <xsl:call-template name="perceptive_structures">
                      <xsl:with-param name="number" select="$perception_nbr"/>
                    </xsl:call-template>
                    <xsl:call-template name="conception_types">
                      <xsl:with-param name="number" select="$conception_nbr"/>
                    </xsl:call-template>
                  </xsl:element>
              </xsl:element>
            </xsl:element>
          </xsl:element>
          <xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
            <xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
              <xsl:attribute name="name">
                <xsl:value-of select="'initialization'"/>
              </xsl:attribute>
              <xsl:call-template name="initialization_rules">
                  <xsl:with-param name="number" select="$conception_nbr"/>
              </xsl:call-template>
              <xsl:element name="rule" namespace="http://www.nomoseed.org/program">
                <xsl:attribute name="name">
                  <xsl:value-of select="'time'"/>
                </xsl:attribute>
                <xsl:attribute name="relevance">
                  <xsl:value-of select="1"/>
                </xsl:attribute>
                <xsl:element name="conclusion" namespace="http://www.nomoseed.org/program">
                  <xsl:attribute name="type">
                    <xsl:value-of select="'time'"/>
                  </xsl:attribute>
                  <xsl:attribute name="category">
                    <xsl:value-of select="'command'"/>
                  </xsl:attribute>
                  <xsl:attribute name="model">
                    <xsl:value-of select="'test'"/>
                  </xsl:attribute>
                  <xsl:element name="information" namespace="http://www.nomoseed.org/program">
                    <xsl:attribute name="value">
                      <xsl:value-of select="'time'"/>
                    </xsl:attribute>
                  </xsl:element>
                  <xsl:element name="output" namespace="http://www.nomoseed.org/program">
                    <xsl:attribute name="value">
                      <xsl:value-of select="0"/>
                    </xsl:attribute>
                  </xsl:element>
                </xsl:element>
              </xsl:element>
            </xsl:element>
            <xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
              <xsl:attribute name="name">
                <xsl:value-of select="'evaluation'"/>
              </xsl:attribute>
              <xsl:call-template name="perceptions">
                <xsl:with-param name="number" select="$perception_nbr"/>
              </xsl:call-template>
              <xsl:call-template name="conceptions">
                <xsl:with-param name="number" select="$conception_nbr"/>
              </xsl:call-template>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>
    
  <xsl:template name="perceptive_structures">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="perceptive_structure" namespace="http://www.nomoseed.org/model">
        <xsl:attribute name="name">
          <xsl:value-of select="concat('perception_', $i)"/>
        </xsl:attribute>
        <xsl:element name="items" namespace="http://www.nomoseed.org/model">
          <xsl:call-template name="items">
            <xsl:with-param name="number" select="$maximum_of_rules_by_type"/>
          </xsl:call-template>
        </xsl:element>
        <xsl:element name="components" namespace="http://www.nomoseed.org/model">
          <xsl:call-template name="components">
            <xsl:with-param name="number" select="$maximum_of_components"/>
          </xsl:call-template>
        </xsl:element>
      </xsl:element>
      <xsl:call-template name="perceptive_structures">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
    <xsl:template name="conception_types">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="conception_type" namespace="http://www.nomoseed.org/model">
        <xsl:attribute name="name">
          <xsl:value-of select="concat('conception_', $i)"/>
        </xsl:attribute>
        <xsl:element name="items" namespace="http://www.nomoseed.org/model">
          <xsl:element name="item" namespace="http://www.nomoseed.org/model">
            <xsl:attribute name="name">
              <xsl:value-of select="'item'"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
      </xsl:element>
      <xsl:call-template name="conception_types">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="components">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="component" namespace="http://www.nomoseed.org/model">
        <xsl:attribute name="name">
          <xsl:value-of select="concat('component_', $i)"/>
        </xsl:attribute>
      </xsl:element>
      <xsl:call-template name="components">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
    
  <xsl:template name="items">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="item" namespace="http://www.nomoseed.org/model">
        <xsl:attribute name="name">
          <xsl:value-of select="concat('percept_', $i)"/>
        </xsl:attribute>
      </xsl:element>
      <xsl:call-template name="items">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
    
  <xsl:template name="initialization_rules">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
     <xsl:element name="rule" namespace="http://www.nomoseed.org/program">
        <xsl:attribute name="name">
          <xsl:value-of select="concat('initialization_', $i)"/>
        </xsl:attribute>
        <xsl:attribute name="relevance">
          <xsl:value-of select="1"/>
        </xsl:attribute>
        <xsl:element name="conclusion" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="type">
            <xsl:value-of select="concat('conception_', $i)"/>
          </xsl:attribute>
          <xsl:attribute name="category">
            <xsl:value-of select="'conception'"/>
          </xsl:attribute>
          <xsl:attribute name="model">
            <xsl:value-of select="'test'"/>
          </xsl:attribute>
          <xsl:element name="information" namespace="http://www.nomoseed.org/program">
            <xsl:attribute name="value">
              <xsl:value-of select="'item'"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
      </xsl:element>
      <xsl:call-template name="initialization_rules">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="perceptions">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:call-template name="perception_rules">
        <xsl:with-param name="number" select="$maximum_of_rules_by_type"/>
        <xsl:with-param name="type" select="concat('perception_', $i)"/>
      </xsl:call-template>
      <xsl:call-template name="perceptions">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
    
  <xsl:template name="perception_rules">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:param name="type"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="rule" namespace="http://www.nomoseed.org/program">
        <xsl:attribute name="name">
          <xsl:value-of select="concat($type, '_', $i)"/>
        </xsl:attribute>
        <xsl:attribute name="relevance">
          <xsl:value-of select="$relevance"/>
        </xsl:attribute>
        <xsl:attribute name="fitting_nbr">
          <xsl:value-of select="$fitting_nbr"/>
        </xsl:attribute>
        <xsl:element name="premise" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="type">
            <xsl:value-of select="$type"/>
          </xsl:attribute>
          <xsl:attribute name="category">
            <xsl:value-of select="'input'"/>
          </xsl:attribute>
          <xsl:attribute name="model">
            <xsl:value-of select="'test'"/>
          </xsl:attribute>
          <xsl:call-template name="informations">
            <xsl:with-param name="number" select="$maximum_of_components"/>
          </xsl:call-template>
        </xsl:element>
        <xsl:call-template name="sequence_premises">
          <xsl:with-param name="number" select="$perception_sequence_nbr"/>
        </xsl:call-template>
        <xsl:call-template name="remainder_premises">
          <xsl:with-param name="number" select="$perception_remainder"/>
          <xsl:with-param name="type" select="concat('conception_', $perception_sequence_nbr + 1)"/>
        </xsl:call-template>
        <xsl:element name="conclusion" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="type">
            <xsl:value-of select="$type"/>
          </xsl:attribute>
          <xsl:attribute name="category">
            <xsl:value-of select="'perception'"/>
          </xsl:attribute>
          <xsl:attribute name="model">
            <xsl:value-of select="'test'"/>
          </xsl:attribute>
          <xsl:element name="information" namespace="http://www.nomoseed.org/program">
            <xsl:attribute name="value">
              <xsl:value-of select="concat('percept_', $i)"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
      </xsl:element>
      <xsl:call-template name="perception_rules">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
        <xsl:with-param name="type" select="$type"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
    
  <xsl:template name="conceptions">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:call-template name="conception_rules">
        <xsl:with-param name="number" select="$maximum_of_rules_by_type"/>
        <xsl:with-param name="type" select="concat('conception_', $i)"/>
      </xsl:call-template>
      <xsl:call-template name="conceptions">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="conception_rules">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:param name="type"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="rule" namespace="http://www.nomoseed.org/program">
        <xsl:attribute name="name">
          <xsl:value-of select="concat($type, '_', $i)"/>
        </xsl:attribute>
        <xsl:attribute name="relevance">
          <xsl:value-of select="$relevance"/>
        </xsl:attribute>
        <xsl:attribute name="fitting_nbr">
          <xsl:value-of select="$fitting_nbr"/>
        </xsl:attribute>
        <xsl:call-template name="sequence_premises">
          <xsl:with-param name="number" select="$sequence_nbr"/>
        </xsl:call-template>
        <xsl:call-template name="remainder_premises">
          <xsl:with-param name="number" select="$remainder"/>
          <xsl:with-param name="type" select="concat('conception_', $sequence_nbr + 1)"/>
        </xsl:call-template>
        <xsl:element name="conclusion" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="type">
            <xsl:value-of select="$type"/>
          </xsl:attribute>
          <xsl:attribute name="category">
            <xsl:value-of select="'conception'"/>
          </xsl:attribute>
          <xsl:attribute name="model">
            <xsl:value-of select="'test'"/>
          </xsl:attribute>
          <xsl:element name="information" namespace="http://www.nomoseed.org/program">
            <xsl:attribute name="value">
              <xsl:value-of select="'item'"/>
            </xsl:attribute>
            <xsl:attribute name="delay">
              <xsl:value-of select="0"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
      </xsl:element>
      <xsl:call-template name="conception_rules">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
        <xsl:with-param name="type" select="$type"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="informations">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="information" namespace="http://www.nomoseed.org/program">
        <xsl:attribute name="tolerance">
          <xsl:value-of select="10"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="1"/>
        </xsl:attribute>
      </xsl:element>
      <xsl:call-template name="informations">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="remainder_premises">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:param name="type"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:element name="premise" namespace="http://www.nomoseed.org/program">
        <xsl:attribute name="type">
          <xsl:value-of select="$type"/>
        </xsl:attribute>
        <xsl:attribute name="category">
          <xsl:value-of select="'conception'"/>
        </xsl:attribute>
        <xsl:attribute name="model">
          <xsl:value-of select="'test'"/>
        </xsl:attribute>
        <xsl:element name="information" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="tolerance">
            <xsl:value-of select="0"/>
          </xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="'item'"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="credibility" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="tolerance">
            <xsl:value-of select="$tolerance_credibility"/>
          </xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="0.5"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="timespan" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="tolerance">
            <xsl:value-of select="$tolerance_timespan"/>
          </xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="$i - 1"/>
          </xsl:attribute>
        </xsl:element>
      </xsl:element>
      <xsl:call-template name="remainder_premises">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
        <xsl:with-param name="type" select="$type"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="sequence_premises">
    <xsl:param name="i" select="1"/>
    <xsl:param name="number"/>
    <xsl:if test="$i &lt;= $number">
      <xsl:call-template name="remainder_premises">
        <xsl:with-param name="number" select="$maximum_of_internal_events"/>
        <xsl:with-param name="type" select="concat('conception_', $i)"/>
      </xsl:call-template>
      <xsl:call-template name="sequence_premises">
        <xsl:with-param name="i" select="$i + 1"/>
        <xsl:with-param name="number" select="$number"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
    