//  Copyright (2010-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, version 2 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

var basicName = new RegExp("[a-zA-Z]+[a-zA-Z0-9_]*","i");
var nameOrigin;

function setProjectType()
{
	nomoSDK.setProjectType(this.value);
	if (this.value=="prg" || this.value=="mod")
		document.getElementById("formalism").disabled = "";
	else
		document.getElementById("formalism").disabled = "disabled";	
}

function setProjectName()
{
	if (this.value == "")
		document.getElementById("location").disabled = "disabled";
	else {
		if(basicName.test(this.value))
		{
			document.getElementById("location").disabled = "";
			nomoSDK.setProjectName(this.value);
		}
		else
		{
			document.getElementById("location").disabled = "disabled";
		}
	}
}

function changeLanguage()
{
	nomoSDK.changeLanguage(this.value);
}

function action(){}

function init (evt)
{
	document.getElementById("project").onclick = nomoSDK.openProject;
	document.getElementById("database").onclick = nomoSDK.openDatabase;
	var types = document.getElementsByName("type");
	for (i in types)
	{
		types[i].onclick = setProjectType;
	}
	document.getElementById("name").onkeyup = setProjectName;
	document.getElementById("location").disabled = "disabled";
	document.getElementById("location").onclick = nomoSDK.chooseProjectLocation;
	document.getElementById("language").onchange = changeLanguage;
	var forms = document.getElementsByTagName("form");
	for (i in forms)
	{
		forms[i].action = action;
	}
}

window.onload = init;