<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdk="http://www.nomoseed.org/nomosdk" xmlns="http://www.w3.org/1999/xhtml">
	<xsl:output method="xml" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" standalone="yes" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" indent="no" encoding="utf-8"/>
	<xsl:param name="open" select="'Open'"/>
	<xsl:param name="add" select="'Add'"/>
	<xsl:param name="reset" select="'Reset'"/>
	<xsl:param name="table" select="'Table'"/>
	<xsl:param name="graphic" select="'Graphic'"/>
	<xsl:param name="export" select="'Export'"/>
	<xsl:param name="database" select="'Database'"/>
	<xsl:param name="view" select="'View'"/>
	<xsl:param name="query" select="'Query'"/>
	<xsl:template match="/sdk:logging">
		<html id="logging" class="background">
			<head>
				<title>Logging</title>
				<link rel="stylesheet" type="text/css" href="../share/nomoSDK.css"/>
				<link rel="stylesheet" type="text/css" href="logging.css"/>
				<script type="application/ecmascript" src="logging.js"/>
			</head>
			<body>
				<div id="ihm" class="box">
					<form action="">
            <fieldset id="database">
              <legend><xsl:value-of select="$database"/></legend>
              <div class="decoration">
                  <input id="open" class="light big" type="button" value="{$open}"/>
                  <input id="add" class="light big limited" type="button" value="{$add}"/>
                  <input id="reset" class="light big limited" type="button" value="{$reset}"/>
              </div>
            </fieldset>
            <fieldset id="query">
              <legend><xsl:value-of select="$query"/></legend>
              <div class="decoration">
                <textarea placeholder="SQL">SELECT rule.name AS rule_name, type.name AS type_name, category, type.type_id, hue, luminance, saturation FROM rule JOIN type ON type.type_id = rule.type_id</textarea>
              </div>
            </fieldset>
            <fieldset id="view">
              <legend><xsl:value-of select="$view"/></legend>
              <div class="decoration">
                  <input id="table" class="light big limited" type="button" value="{$table}"/>
                  <input id="graphic" class="light big limited" type="button" value="{$graphic}"/>
                  <input id="export" class="light big limited" type="button" value="{$export}"/>
              </div>
            </fieldset>
					</form>
				</div>
				<div id="screen" class="box">
        <p><xsl:value-of select="$view"/></p>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
