<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">
	<xsl:output method="xml"
              indent="yes"
              encoding="utf-8"
              omit-xml-declaration="yes"/>
	<xsl:template match="/">
  <div id="workspace">
    <div class="barspace">
      <div class="undo ui"><span> </span></div>
      <div class="redo ui"><span> </span></div>
      <div class="indent ui"><span> </span></div>
      <div class="case_sensitive ui sensitive"><span> </span></div>
      <input class="search ui" type="text" value=""/>
      <div class="search_tools" style="visibility:hidden">
        <div class="previous ui"><span> </span></div>
        <div class="next ui"><span> </span></div>
        <input type="text" value="" class="word ui" />
        <div class="replace ui"><span> </span></div>
        <div class="replace_all ui"><span> </span></div>
      </div>
      <div class="link ui" style="display: none"><span> </span></div>
      <div class="color ui" style="display: none"><span> </span></div>
      <div class="interface ui" style="visibility: hidden">
        <form action="">
          <fieldset>
            <select>
              <option value="none" selected="selected">
                <xsl:value-of select="'any interface'"/>
              </option>
              <xsl:for-each select="document('../../interfaces.xml')/interfaces/interface">
                <option value="{@language}_{@extension}">
                  <xsl:value-of select="@language"/>
                </option>
              </xsl:for-each>
            </select>
          </fieldset>
        </form>
      </div>
    </div>
    <div class="visualisationspace">
      <div class="text">
        <div class="box codespace">
          <form>
            <div>
              <textarea class="code" name="code">
                <xsl:copy-of select="."/>
              </textarea>
            </div>
          </form>
        </div>
        <div class="splitter"><span> </span></div>
        <div class="validationspace box"><span> </span></div>
      </div>
    </div>
  </div>
	</xsl:template>
</xsl:stylesheet>
