<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:program="http://www.nomoseed.org/program"
                xmlns:model="http://www.nomoseed.org/model"
                xmlns:engine="http://www.nomoseed.org/inference_engine"
                xmlns:unit="http://www.nomoseed.org/unit"
                xmlns:base="http://www.nomoseed.org/knowledge_base"
                xmlns:sdk="http://www.nomoseed.org/sdk"
                xmlns:xi="http://www.w3.org/2001/XInclude"
                xmlns="http://www.w3.org/1999/xhtml"
                exclude-result-prefixes="program model engine unit base sdk xi">
	<xsl:output method="html"
              doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
              standalone="no" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
              indent="no"
              encoding="utf-8"
              omit-xml-declaration="yes"/>
	<xsl:key name="modelKey" match="program:program/program:body/program:models/program:*" use="@instance"/>
	<xsl:param name="number" select="0"/>
	<xsl:param name="modified" select="1"/>
	<xsl:param name="plant" select="'plant'"/>
	<xsl:variable name="id" select="concat(substring(local-name(/*),1,1),$number)" />
	<xsl:variable name="model" select="/model:model/@name"/>
	<xsl:template match="/program:program">
		<li rel="program" id="{$id}">
			<a ref="#">
				<xsl:value-of select="@name"/>
				<xsl:if test="$modified">
					<span class="modified"> *</span>
				</xsl:if>
			</a>
       <ul>
          <xsl:if test="program:sdk/sdk:formalism">
            <li rel="formalism" id="{$id}-formalism-{local-name(program:sdk/sdk:formalism/*)}">
              <a ref="#">
                <xsl:value-of select="local-name(program:sdk/sdk:formalism/*)"/>
              </a>
            </li>
          </xsl:if>
          <xsl:apply-templates select="program:sdk/sdk:macro"/>
          <xsl:apply-templates select="program:subprograms/program:*[@instance]" mode="subprogram"/>
          <xsl:apply-templates select="program:body/program:models/program:*[@instance]" mode="model"/>
          <xsl:apply-templates select="program:body/program:scheme/program:scheme | program:body/program:scheme/program:rule | program:body/program:scheme/program:template/program:rule"/>
        </ul>
		</li>
	</xsl:template>
	<xsl:template match="sdk:macro">
    <li rel="macro" id="{$id}-macro-{@name}">
      <a ref="#">
        <xsl:value-of select="@name"/>
      </a>
    </li>
	</xsl:template>
	<xsl:template match="program:scheme">
		<li rel="scheme" id="{$id}-scheme-{@name}">
			<a ref="#">
				<xsl:value-of select="@name"/>
			</a>
			<xsl:variable name="others" select="./program:scheme | ./program:rule | ./program:template/program:rule"/>
			<xsl:if test="count($others)&gt;0">
				<ul>
					<xsl:apply-templates select="$others"/>
				</ul>
			</xsl:if>
		</li>
	</xsl:template>
	<xsl:template match="program:rule">
		<xsl:variable name="model">
			<xsl:choose>
				<xsl:when test="key('modelKey',program:conclusion/@model)/model:model">
					<xsl:value-of select="key('modelKey',program:conclusion/@model)/model:model/@name"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="extract">
						<xsl:with-param name="href" select="key('modelKey',program:conclusion/@model)/xi:include/@href"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li rel="{program:conclusion/@category}_rule" id="{$id}-rule-{@name}" class="m_{$model} i_{program:conclusion/@model} t_{program:conclusion/@type} c_{program:conclusion/@category}">
			<a ref="#">
				<xsl:value-of select="@name"/>
			</a>
		</li>
	</xsl:template>
	<xsl:template match="program:*[@instance]" mode="model">
		<xsl:variable name="model">
			<xsl:choose>
				<xsl:when test="model:model">
					<xsl:value-of select="concat('model-',model:model/@name)"/>
				</xsl:when>
				<xsl:otherwise>
          <xsl:call-template name="extract">
            <xsl:with-param name="href" select="xi:include/@href"/>
          </xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li rel="model_instance" id="{$id}-{local-name()}-{@instance}">
			<a ref="#" ondblclick="nomoOpen('{xi:include/@href}')">
				<xsl:value-of select="concat(@instance,' [',$model,']')"/>
			</a>
		</li>
	</xsl:template>
	<xsl:template match="program:*[@instance]" mode="subprogram">
		<xsl:variable name="subprogam">
			<xsl:choose>
				<xsl:when test="program:program">
					<xsl:value-of select="program:program/@name"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="extract">
						<xsl:with-param name="href" select="xi:include/@href"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li rel="program_instance" id="{$id}-{local-name()}-{@instance}">
			<a ref="#" ondblclick="nomoOpen('{xi:include/@href}')">
				<xsl:value-of select="concat(@instance,' [',$subprogam,']')"/>
			</a>
		</li>
	</xsl:template>
	<xsl:template match="/model:model">
		<xsl:variable name="base">
			<xsl:choose>
				<xsl:when test="model:base/model:model">
					<xsl:value-of select="model:base/model:model/@name"/>
				</xsl:when>
				<xsl:when test="model:base/xi:include">
          <xsl:call-template name="extract">
            <xsl:with-param name="href" select="model:base/xi:include/@href"/>
          </xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li rel="model" id="{$id}">
			<a ref="#">
				<xsl:value-of select="@name"/>
				<xsl:if test="$modified">
					<span class="modified"> *</span>
				</xsl:if>
			</a>
			<ul>
				<xsl:if test="$base != 'no'">
					<li rel="base" id="{$id}-base">
						<a ref="#" ondblclick="nomoOpen('{model:base/xi:include/@href}')">
							<xsl:value-of select="$base"/>
						</a>
					</li>
				</xsl:if>
				<xsl:apply-templates select="model:definition/model:*"/>
			</ul>
		</li>
	</xsl:template>
	<xsl:template match="model:perceptive_structure">
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="@name"/>
			<xsl:with-param name="category" select="'perception'"/>
			<xsl:with-param name="extra_1" select="'input'"/>
			<xsl:with-param name="others" select="./model:command_type | ./model:conception_type | ./model:predicted_by | ./model:rewarded_by"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="model:predictive_structure">
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="@name"/>
			<xsl:with-param name="category" select="'prediction'"/>
			<xsl:with-param name="extra_1" select="'landmark'"/>
			<xsl:with-param name="extra_2" select="'check'"/>
			<xsl:with-param name="others" select="./model:command_type |./model:conception_type | ./model:predicted_by | ./model:rewarded_by"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="model:plant_structure">
		<li rel="plant_structure" id="{$id}-plant_structure">
			<a ref="#">
				<xsl:value-of select="$plant"/>
			</a>
			<ul>
				<xsl:if test="model:rewarded_by">
					<li rel="reward" id="{$id}-rewarded_by-{model:rewarded_by/@name}" class="m_{$model} t_{model:rewarded_by/@name} c_reward">
						<a ref="#">
							<xsl:value-of select="model:rewarded_by/@name"/>
						</a>
					</li>
				</xsl:if>
				<!--li rel="transition" id="{$id}-plant-transition" class="m_{$model} t_transition c_transition">
					<a ref="#">
						<xsl:value-of select="'transition'"/>
					</a>
				</li>
				<li rel="anomaly" id="{$id}-plant-anomaly" class="m_{$model} t_anomaly c_anomaly">
					<a ref="#">
						<xsl:value-of select="'anomaly'"/>
					</a>
				</li-->
        
				<li rel="scope" id="{$id}-input-scope" class="m_{$model} t_register_00 c_scope">
					<a ref="#">
						<xsl:value-of select="'register_00'"/>
					</a>
				</li>
				<li rel="operator" id="{$id}-input-operator" class="m_{$model} t_register_00 c_operator">
					<a ref="#">
						<xsl:value-of select="'register_00'"/>
					</a>
				</li>
				<li rel="scope" id="{$id}-other-scope" class="m_{$model} t_register_01 c_scope">
					<a ref="#">
						<xsl:value-of select="'register_0X'"/>
					</a>
				</li>
				<li rel="operator" id="{$id}-other-operator" class="m_{$model} t_register_01 c_operator">
					<a ref="#">
						<xsl:value-of select="'register_0X'"/>
					</a>
				</li>
			</ul>
    </li>
	</xsl:template>
	<xsl:template match="model:conception_type">
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="@name"/>
			<xsl:with-param name="category" select="'conception'"/>
			<xsl:with-param name="others" select="./model:conception_type | ./model:predicted_by | ./model:rewarded_by"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="model:command_type">
		<xsl:variable name="name">
			<xsl:choose>
				<xsl:when test="@name">
					<xsl:value-of select="@name"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="../@name"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="$name"/>
			<xsl:with-param name="category" select="'command'"/>
			<xsl:with-param name="others" select="./model:conception_type"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="model:reward_type">
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="@name"/>
			<xsl:with-param name="category" select="'reward'"/>
			<xsl:with-param name="others" select="./model:conception_type"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="model:landmark_type">
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="@name"/>
			<xsl:with-param name="category" select="'landmark'"/>
			<xsl:with-param name="others" select="./model:rewarded_by"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="add_type">
		<xsl:param name="type"/>
		<xsl:param name="category"/>
		<xsl:param name="extra_1" select="''"/>
		<xsl:param name="extra_2" select="''"/>
		<xsl:param name="others"/>
		<xsl:variable name="nbr_others">
			<xsl:choose>
				<xsl:when test="$others and $others != 'no'">
					<xsl:value-of select="count($others)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="name">
			<xsl:choose>
				<xsl:when test="$extra_1 and $extra_2">
					<xsl:value-of select="'predictive_structure'"/>
				</xsl:when>
				<xsl:when test="$extra_1">
					<xsl:value-of select="'perceptive_structure'"/>
				</xsl:when>
				<xsl:when test="$others = 'no' and $category='reward'">
					<xsl:value-of select="'rewarded_by'"/>
				</xsl:when>
				<xsl:when test="$others = 'no' and $category='prediction'">
					<xsl:value-of select="'predicted_by'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($category,'_type')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li rel="{$category}" id="{$id}-{$name}-{$type}" class="m_{$model} t_{$type} c_{$category}">
			<a ref="#">
				<xsl:value-of select="$type"/>
			</a>
			<xsl:if test="$nbr_others&gt;0 or $extra_1 or $extra_2">
				<ul>
					<xsl:if test="$extra_1">
						<li rel="{$extra_1}" id="{$id}-{$name}-{$type}-{$extra_1}" class="m_{$model} t_{$type} c_{$extra_1}">
							<a ref="#">
								<xsl:value-of select="$type"/>
							</a>
						</li>
					</xsl:if>
					<xsl:if test="$extra_2">
						<li rel="{$extra_2}" id="{$id}-{$name}-{$type}-{$extra_2}" class="m_{$model} t_{$type} c_{$extra_2}">
							<a ref="#">
								<xsl:value-of select="$type"/>
							</a>
						</li>
					</xsl:if>
					<xsl:apply-templates select="$others"/>
				</ul>
			</xsl:if>
		</li>
	</xsl:template>
	<xsl:template match="model:predicted_by">
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="@name"/>
			<xsl:with-param name="category" select="'prediction'"/>
			<xsl:with-param name="others" select="'no'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="model:rewarded_by">
		<xsl:call-template name="add_type">
			<xsl:with-param name="type" select="@name"/>
			<xsl:with-param name="category" select="'reward'"/>
			<xsl:with-param name="others" select="'no'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="/engine:inference_engine">
		<li rel="engine" id="{concat('e',substring-after($id,'i'))}" class="">
			<a ref="#">
				<xsl:value-of select="@name"/>
				<xsl:if test="$modified">
					<span class="modified"> *</span>
				</xsl:if>
			</a>
		</li>
	</xsl:template>
	<xsl:template match="/base:knowledge_base">
		<li rel="knowledge" id="{concat('b',substring-after($id,'k'))}" class="">
			<a ref="#">
				<xsl:value-of select="@name"/>
				<xsl:if test="$modified">
					<span class="modified"> *</span>
				</xsl:if>
			</a>
		</li>
	</xsl:template>
	<xsl:template match="/unit:unit">
		<xsl:variable name="engine">
			<xsl:choose>
				<xsl:when test="engine:inference_engine">
					<xsl:value-of select="engine:inference_engine/@name"/>
				</xsl:when>
				<xsl:when test="xi:include[contains(@href,'.eng')]">
          <xsl:call-template name="extract">
            <xsl:with-param name="href" select="xi:include[contains(@href,'.eng')]/@href"/>
          </xsl:call-template>
					<xsl:value-of select="'.eng'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="base">
			<xsl:choose>
				<xsl:when test="base:knowledge_base">
					<xsl:value-of select="base:knowledge_base/@name"/>
				</xsl:when>
				<xsl:when test="xi:include[contains(@href,'.bas')]">
          <xsl:call-template name="extract">
            <xsl:with-param name="href" select="xi:include[contains(@href,'.bas')]/@href"/>
          </xsl:call-template>
					<xsl:value-of select="'.bas'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="program">
			<xsl:choose>
				<xsl:when test="program:program">
					<xsl:value-of select="program:program/@name"/>
				</xsl:when>
				<xsl:when test="xi:include[contains(@href,'.prg')]">
					<xsl:call-template name="extract">
						<xsl:with-param name="href" select="xi:include[contains(@href,'.prg')]/@href"/>
					</xsl:call-template>
					<xsl:value-of select="'.prg'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li rel="unit"  id="{$id}">
			<a ref="#">
				<xsl:value-of select="@name"/>
				<xsl:if test="$modified">
					<span class="modified"> *</span>
				</xsl:if>
			</a>
			<ul>
        <xsl:choose>
          <xsl:when test="xi:include[contains(@href,'.eng')]">
          <li rel="engine" id="{$id}-{local-name(./xi:include[contains(@href,'.eng')])}-{$engine}">
            <a ref="#" ondblclick="nomoOpen('{xi:include[contains(@href,'.eng')]/@href}')">
              <xsl:value-of select="substring-before($engine,'.')"/>
            </a>
          </li>
          </xsl:when>
          <xsl:otherwise>
          <li rel="engine" id="{$id}-{local-name(./engine:inference_engine)}-{$engine}">
            <a ref="#" ondblclick="">
              <xsl:value-of select="$engine"/>
            </a>
          </li>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="xi:include[contains(@href,'.bas')]">
            <li rel="knowledge" id="{$id}-{local-name(./xi:include[contains(@href,'.bas')])}-{$base}">
              <a ref="#" ondblclick="nomoOpen('{xi:include[contains(@href,'.bas')]/@href}')">
                <xsl:value-of select="substring-before($base,'.')"/>
              </a>
            </li>
          </xsl:when>
          <xsl:otherwise>
            <li rel="knowledge" id="{$id}-{local-name(./base:knowledge_base)}-{$base}">
              <a ref="#" ondblclick="">
                <xsl:value-of select="$base"/>
              </a>
            </li>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="xi:include[contains(@href,'.prg')]">
            <li rel="program" id="{$id}-{local-name(./xi:include[contains(@href,'.prg')])}-{$program}">
              <a ref="#" ondblclick="nomoOpen('{xi:include[contains(@href,'.prg')]/@href}')">
                <xsl:value-of select="substring-before($program,'.')"/>
              </a>
            </li>
          </xsl:when>
          <xsl:otherwise>
            <li rel="program" id="{$id}-{local-name(./base:program)}-{$program}">
              <a ref="#" ondblclick="">
                <xsl:value-of select="$program"/>
              </a>
            </li>
          </xsl:otherwise>
        </xsl:choose>
			</ul>
		</li>
	</xsl:template>
	<xsl:template name="extract">
		<xsl:param name="href"/>
		<xsl:choose>
			<xsl:when test="contains($href,'\')">
				<xsl:call-template name="extract">
					<xsl:with-param name="href" select="substring-after($href,'\')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($href,'/')">
				<xsl:call-template name="extract">
					<xsl:with-param name="href" select="substring-after($href,'/')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring-before($href,'.')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
