<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ws="http://www.nomoseed.org/worldsquare">
	<xsl:output method="xml" standalone="no" indent="no" encoding="utf-8"/>
	<xsl:key name="slabKey" match="ws:slab" use="@id"/>
	<xsl:variable name="xMin">
		<xsl:for-each select="/ws:worldsquare/ws:slab">
			<xsl:sort select="@x" data-type="number" order="ascending"/>
			<xsl:if test="position() = 1">
				<xsl:value-of select="@x - 1"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="yMin">
		<xsl:for-each select="/ws:worldsquare/ws:slab">
			<xsl:sort select="@y" data-type="number" order="ascending"/>
			<xsl:if test="position() = 1">
				<xsl:value-of select="@y - 1"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:template match="ws:worldsquare">
		<xsl:choose>
			<xsl:when test="$xMin = 0 and $yMin = 0">
				<xsl:copy-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:attribute name="name">
						<xsl:value-of select="@name"/>
					</xsl:attribute>
					<xsl:apply-templates/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ws:slab">
		<xsl:copy>
			<xsl:attribute name="hue">
				<xsl:value-of select="@hue"/>
			</xsl:attribute>
			<xsl:attribute name="x">
				<xsl:value-of select="@x - $xMin"/>
			</xsl:attribute>
			<xsl:attribute name="y">
				<xsl:value-of select="@y - $yMin"/>
			</xsl:attribute>
			<xsl:attribute name="id">
				<xsl:value-of select="concat(@x - $xMin,@y - $yMin)"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:agent">
		<xsl:variable name="slab" select="key('slabKey',@on)"/>
		<xsl:copy>
			<xsl:attribute name="on">
				<xsl:value-of select="concat($slab/@x - $xMin, $slab/@y - $yMin)"/>
			</xsl:attribute>
			<xsl:attribute name="direction">
				<xsl:value-of select="@direction"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match=" ws:sphere">
		<xsl:variable name="slab" select="key('slabKey',@on)"/>
		<xsl:copy>
			<xsl:attribute name="on">
				<xsl:value-of select="concat($slab/@x - $xMin, $slab/@y - $yMin)"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:agent/ws:sphere | ws:sonar | ws:bumper | ws:hue | ws:sum_sounds">
		<xsl:copy-of select="."/>
	</xsl:template>
</xsl:stylesheet>
