<?xml version="1.0" encoding="utf-8" ?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" exclude-result-prefixes="ws" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:ws="http://www.nomoseed.org/worldsquare" xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/1999/xhtml">
	<xsl:output method="xml" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" standalone="yes" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" indent="no" encoding="utf-8"/>
	<xsl:param name="unitName" select="''"/>
	<xsl:param name="logFlagValue" select="'4'"/>
	<xsl:param name="logPositionFlagValue" select="'1'"/>
	<xsl:param name="fileFlagValue" select="'3'"/>
	<xsl:param name="animationValue" select="'1'"/>
	<xsl:param name="dataName" select="'The map'"/>
	<xsl:param name="startState" select="'start'"/>
	<xsl:param name="progression" select="'100'"/>
	<xsl:param name="stepsNumber" select="'1'"/>
	<xsl:param name="finalValue" select="'3'"/>
	<xsl:param name="agentsNbrUnit" select="'10000'"/>
	<xsl:param name="selectUnit" select="'Select unit'"/>
	<xsl:param name="loggingLegend" select="'Logging'"/>
	<xsl:param name="logFlagLabel" select="'For every steps: '"/>
	<xsl:param name="logFlagOption0" select="'Partialy log the winner'"/>
	<xsl:param name="logFlagOption1" select="'Completely log the winner'"/>
	<xsl:param name="logFlagOption2" select="'Partialy log all rules'"/>
	<xsl:param name="logFlagOption3" select="'Completely log all rules'"/>
	<xsl:param name="logFlagOption4" select="'No log'"/>
	<xsl:param name="logPositionFlagLabel" select="'For every steps: '"/>
	<xsl:param name="logPositionFlagOption0" select="'Log before selection'"/>
	<xsl:param name="logPositionFlagOption1" select="'Log after selection'"/>
	<xsl:param name="fileFlagLabel" select="'At begin  : '"/>
	<xsl:param name="fileFlagOption0" select="'Create a file of complete log'"/>
	<xsl:param name="fileFlagOption1" select="'Create a file of partial log'"/>
	<xsl:param name="fileFlagOption2" select="'Create any log file'"/>
	<xsl:param name="legendClocking" select="'Clocking'"/>
	<xsl:param name="finalLabel" select="'At end : '"/>
	<xsl:param name="finalOption0" select="'Reinitialize'"/>
	<xsl:param name="finalOption1" select="'Save and reinitialize'"/>
	<xsl:param name="finalOption2" select="'Update and reinitialize'"/>
	<xsl:param name="finalOption3" select="'No reinitialize'"/>
	<xsl:param name="stepsLabel" select="'Number of steps: '"/>
	<xsl:param name="animationLabel" select="'With animation (2Hz): '"/>
	<xsl:param name="animationOption0" select="'No'"/>
	<xsl:param name="animationOption1" select="'Yes'"/>
	<xsl:param name="textHueLabel" select="'Hue of slab (°): '"/>
	<xsl:param name="textSpheresNbrLabel" select="'Number of spheres: '"/>
	<xsl:param name="agentLabel" select="'Agent #'"/>
	<xsl:param name="spheresNbrLabel" select="'  with a number of spheres to '"/>
	<xsl:variable name="xMax">
		<xsl:for-each select="/ws:worldsquare/ws:slab">
			<xsl:sort select="@x" data-type="number" order="descending"/>
			<xsl:if test="position() = 1">
				<xsl:value-of select="@x"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="yMax">
		<xsl:for-each select="/ws:worldsquare/ws:slab">
			<xsl:sort select="@y" data-type="number" order="descending"/>
			<xsl:if test="position() = 1">
				<xsl:value-of select="@y"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="Max">
		<xsl:choose>
			<xsl:when test="$xMax &gt; $yMax">
				<xsl:value-of select="$xMax"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$yMax"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="agentsNbr">
		<xsl:choose>
			<xsl:when test="$agentsNbrUnit &gt; count(//ws:agent)">
				<xsl:value-of select="count(//ws:agent)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$agentsNbrUnit"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="dx" select="50"/>
	<xsl:variable name="dy" select="24"/>
	<xsl:variable name="hView" select="($Max * 2 - ($xMax - $yMax)*(($xMax &gt;= $yMax) - not($xMax &gt;=$yMax)) +3)*$dy"/>
	<xsl:variable name="wView" select="($Max * 2 + 6)*$dx"/>
	<xsl:variable name="shiftX" select="($wView - ($xMax - $yMax)*$dx) div 2"/>
	<xsl:variable name="dur" select="0.45"/>
	<xsl:key name="sphereKey" match="ws:sphere" use="@on"/>
	<xsl:key name="slabKey" match="ws:slab" use="@id"/>
	<xsl:key name="agentKey" match="ws:agent" use="@on"/>
	<xsl:template match="ws:worldsquare | svg:svg">
		<html class="background">
			<head>
				<link rel="stylesheet" type="text/css" href="../share/nomoSDK.css"/>
				<link rel="stylesheet" type="text/css" href="benchmark.css"/>
				<script type="application/ecmascript" src="../share/nomoSDK.js"/>
        <script type="application/ecmascript" src="benchmark_share.js"/>
        <xsl:choose>
          <xsl:when test="local-name(.) = 'worldsquare'">
            <script type="application/ecmascript" src="benchmark_map.js"/>
          </xsl:when>
          <xsl:otherwise>
            <script type="application/ecmascript" src="benchmark_points.js"/>
            <script type="application/ecmascript" src="viewSVG.js"/>
          </xsl:otherwise>
        </xsl:choose>
				<script type="application/ecmascript">
					<xsl:choose>
						<xsl:when test="$unitName=''">
							var hasUnit = false;
						</xsl:when>
						<xsl:otherwise>
							var hasUnit = true;
						</xsl:otherwise>
					</xsl:choose>
					function initializeForm () {
					setProgressBar(<xsl:value-of select="$progression"/>);
					document.getElementById("logFlag").options[<xsl:value-of select="$logFlagValue"/>].selected = "selected";
					document.getElementById("logPositionFlag").options[<xsl:value-of select="$logPositionFlagValue"/>].selected = "selected";
          if (<xsl:value-of select="$fileFlagValue"/> == 3)
            document.getElementById("fileFlag").options[2].selected = "selected";
          else
            document.getElementById("fileFlag").options[<xsl:value-of select="$fileFlagValue"/>].selected = "selected";
					document.getElementById("final").options[<xsl:value-of select="$finalValue"/>].selected = "selected";
					document.getElementById("animation").options[<xsl:value-of select="$animationValue"/>].selected = "selected";
					<xsl:if test="$startState='pause' and local-name(.) = 'worldsquare'">
						worldsquareSVG.setAttribute("class", "noevents");
					</xsl:if>
					}
				</script>
			</head>
			<body>
				<div id="benchmark">
          <xsl:variable name="benchmarkName">
            <xsl:choose>
              <xsl:when test="local-name(.) = 'worldsquare'">
                <xsl:value-of select="'worldsquare'"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="'pointsscatter'"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:variable name="dataType">
            <xsl:choose>
              <xsl:when test="local-name(.) = 'worldsquare'">
                <xsl:value-of select="'map'"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="'points'"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
					<div id="{$benchmarkName}" class="box">
						<div>
							<div id="unit">
								<xsl:choose>
									<xsl:when test="$unitName=''">
										<input class="light big" id="unitSelection" type="button" value="{$selectUnit}"/>
									</xsl:when>
									<xsl:otherwise>
										<input class="light big" id="unitSelection" type="button" value="{$unitName}"/>
									</xsl:otherwise>
								</xsl:choose>
								<input class="light big image" id="unitReloading" type="button"/>
							</div>
							<div id="{$dataType}">
								<input class="light big image" id="{$dataType}Reloading" type="button"/>
								<input class="light big" id="{$dataType}Selection" type="button" value="{$dataName}"/>
							</div>
						</div>
            <xsl:choose>
              <xsl:when test="local-name(.) = 'worldsquare'">
                <svg:svg>
                  <xsl:if test="ws:sum_sounds/@value">
                    <svg:svg viewBox="0 0 {$wView} {$hView}" preserveAspectRatio="xMin* silice">
                      <svg:g>
                        <svg:circle cx="20" cy="20" r="10" visibility="hidden"/>
                        <svg:path d="m 21.920311,0 a 21.920311,22.273863 0 0 1 -21.92031,22.27387" fill="none" stroke="hsl({ws:sum_sounds/@value}, 100%, 50%)" stroke-width="5"/>
                        <svg:animate attributeName="stroke-opacity" attributeType="CSS" values="1;0" begin="0s" dur="{$dur}s" restart="never" fill="freeze"/>
                        <svg:animateTransform attributeName="transform" type="scale" from="0.1" to="80" begin="0s" dur="{$dur}s" restart="never" fill="freeze"/>
                      </svg:g>
                    </svg:svg>
                  </xsl:if>
                  <svg:svg viewBox="0 0 {$wView} {$hView + 100}" preserveAspectRatio="xMidYMid meet">
                    <svg:desc>
                      <xsl:value-of select="@name"/>
                    </svg:desc>
                    <svg:defs>
                      <svg:g id="slab" class="slab">
                        <svg:polygon fill-opacity="0.6" points="50,0 50,16 0,40 0,24"/>
                        <svg:polygon fill-opacity="0.2" points="0,40 0,24 -50,0 -50,16"/>
                        <svg:polygon fill-opacity="1" points="-50,0 0,24 50,0 0,-24"/>
                      </svg:g>
                      <svg:polygon id="head_0" points="-50,0 0,24 26,-11" class="head"/>
                      <svg:polygon id="head_90" points="26,11 -50,0 0,-24" class="head"/>
                      <svg:polygon id="head_180" points="50,0 0,-24 -26,11" class="head"/>
                      <svg:polygon id="head_270" points="-26,-11 50,0 0,24" class="head"/>
                      <svg:rect id="space" width="50" height="50" x="-45" y="-08" rx="10" ry="10" transform="matrix(0.89837819,-0.43922274,0.89837819,0.43922274,0,0)"/>
                      <svg:g id="block" class="select" stroke="#777" stroke-width="1">
                        <svg:polygon fill="#eee" points="-50,0 0,24 50,0 0,-24"/>
                        <svg:polygon fill="#999" points="50,0 50,16 0,40 0,24"/>
                        <svg:polygon fill="#ccc" points="0,40 0,24 -50,0 -50,16"/>
                      </svg:g>
                      <svg:g id="body" class="select" stroke="#777" stroke-width="1">
                        <svg:polygon fill="#111" points="-50,0 0,24 50,0 0,-24"/>
                        <svg:polygon fill="#666" points="50,0 50,16 0,40 0,24"/>
                        <svg:polygon fill="#333" points="0,40 0,24 -50,0 -50,16"/>
                      </svg:g>
                      <xsl:if test="ws:sphere">
                        <svg:g id="sphere">
                          <svg:polygon fill-opacity="0.001" points="-50,0 0,24 50,0 0,-24"/>
                          <svg:g transform="scale(0.5, 0.5) translate(-100, -125)">
                            <svg:linearGradient id="linearGradientSphere">
                              <svg:stop style="stop-color:#fff;stop-opacity:1.0" offset="0.0"/>
                              <svg:stop style="stop-color:#000;stop-opacity:1.0" offset="1.0"/>
                            </svg:linearGradient>
                            <svg:radialGradient cx="100" cy="100" r="20" fx="100" fy="100" id="radialGradientSphere" xlink:href="#linearGradientSphere" gradientUnits="userSpaceOnUse" gradientTransform="matrix(1.0,0.8,-0.8,1.0,95,-95)"/>
                            <svg:filter id="Shadow" filterUnits="userSpaceOnUse" x="-5" y="-5" width="200" height="200">
                              <svg:feGaussianBlur id="blur" in="SourceGraphic" stdDeviation="10" result="flou"/>
                            </svg:filter>
                            <svg:circle cx="100" cy="100" r="20" fill="url(#radialGradientSphere)"/>
                            <svg:ellipse cx="80" cy="140" rx="25" ry="10" fill="black" filter="url(#Shadow)"/>
                          </svg:g>
                        </svg:g>
                      </xsl:if>
                    </svg:defs>
                    <svg:g transform="translate(0,50)">
                      <svg:g id="slabs">
                        <xsl:call-template name="buildSpaces">
                          <xsl:with-param name="x" select="0"/>
                          <xsl:with-param name="y" select="0"/>
                        </xsl:call-template>
                        <xsl:for-each select="ws:slab">
                          <xsl:sort data-type="number" order="ascending" select="@id"/>
                          <xsl:variable name="agent" select="key('agentKey',@id)"/>
                          <xsl:choose>
                            <xsl:when test="$agent and count($agent/preceding-sibling::*[@direction]) &gt;= $agentsNbr">
                              <xsl:call-template name="buildAgentBlock">
                                <xsl:with-param name="agent" select="$agent"/>
                              </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="$agent[not(./ws:advance/@old_on)]">
                              <xsl:call-template name="buildAgentAndOthers">
                                <xsl:with-param name="agent" select="$agent"/>
                              </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="key('sphereKey',@id)">
                              <xsl:variable name="x" select="(@x - @y)*$dx + $shiftX"/>
                              <xsl:variable name="y" select="(@x + @y + 1)*$dy"/>
                              <svg:g class="select" onclick="onClickSphere()" id="{concat(@x,'x',@y)}">
                                <svg:use xlink:href="#slab" x="{$x}" y="{$y}" fill="hsl({@hue}, 100%, 50%)"/>
                                <svg:use xlink:href="#sphere" x="{$x}" y="{$y}"/>
                                <svg:animateTransform attributeName="transform" type="translate" values="0,0;0,-10" begin="mouseover" dur="0.3s" fill="freeze"/>
                                <svg:animateTransform attributeName="transform" type="translate" values="0,10;0,5;0,0" begin="mouseout" dur="0.3s" fill="freeze"/>
                              </svg:g>
                            </xsl:when>
                            <xsl:otherwise>
                              <svg:use xlink:href="#slab" class="select" x="{(@x - @y)*$dx + $shiftX}" y="{(@x + @y + 1)*$dy}" fill="hsl({@hue}, 100%, 50%)" id="{concat(@x,'x',@y)}" onclick="onClickSlab()">
                                <svg:animateTransform attributeName="transform" type="translate" values="0,0;0,-10" begin="mouseover" dur="0.3s" fill="freeze"/>
                                <svg:animateTransform attributeName="transform" type="translate" values="0,10;0,5;0,0" begin="mouseout" dur="0.3s" fill="freeze"/>
                              </svg:use>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:for-each>
                        <xsl:for-each select="ws:agent[./ws:advance/@old_on]">
                          <xsl:sort data-type="number" order="ascending" select="@id"/>
                          <xsl:call-template name="buildAgentAlone"/>
                        </xsl:for-each>
                      </svg:g>
                      <svg:line id="moveControl" x1="0" x2="0" y1="0" y2="0" marker-end="url(#endmarker)"/>
                    </svg:g>
                  </svg:svg>
                </svg:svg> 
              </xsl:when>
              <xsl:otherwise>
                <xsl:copy-of select="." />
              </xsl:otherwise>
            </xsl:choose>
						<div id="action" style="pointer-events:none;">
							<div style="pointer-events:all;">
								<input class="light big image" type="button" id="starting" name="{$startState}" onclick="{$startState}()"/>
							</div>
							<div id="progressBar">
								<span id="progressSize"/>
							</div>
							<div>
								<span id="progressVal"/>
							</div>
						</div>
					</div>
					<div id="controls" class="box {$startState} {concat('one',$stepsNumber)}">
						<form action="">
							<fieldset id="logging" class="decoration">
								<legend>
									<xsl:value-of select="$loggingLegend"/>
								</legend>
								<div>
									<div id="logFlagDiv">
										<label for="logFlag">
											<xsl:value-of select="$logFlagLabel"/>
										</label>
										<select id="logFlag" onchange="changeLogFlag()">
											<option value="0">
												<xsl:value-of select="$logFlagOption0"/>
											</option>
											<option value="1">
												<xsl:value-of select="$logFlagOption1"/>
											</option>
											<option value="2">
												<xsl:value-of select="$logFlagOption2"/>
											</option>
											<option value="3">
												<xsl:value-of select="$logFlagOption3"/>
											</option>
											<option value="4">
												<xsl:value-of select="$logFlagOption4"/>
											</option>
										</select>
									</div>
									<label for="logPositionFlag" style="visibility:hidden">
										<xsl:value-of select="$logPositionFlagLabel"/>
									</label>
									<select id="logPositionFlag" onchange="changeLogPositionFlag()">
										<option value="0">
											<xsl:value-of select="$logPositionFlagOption0"/>
										</option>
										<option value="1" selected="selected">
											<xsl:value-of select="$logPositionFlagOption1"/>
										</option>
									</select>
								</div>
								<div>
									<label for="fileFlag">
										<xsl:value-of select="$fileFlagLabel"/>
									</label>
									<select id="fileFlag" onchange="changeFileFlag()">
										<option value="0">
											<xsl:value-of select="$fileFlagOption0"/>
										</option>
										<option value="1">
											<xsl:value-of select="$fileFlagOption1"/>
										</option>
										<option value="3">
											<xsl:value-of select="$fileFlagOption2"/>
										</option>
									</select>
								</div>
							</fieldset>
							<fieldset id="clocking" class="decoration">
								<legend>
									<xsl:value-of select="$legendClocking"/>
								</legend>
								<div>
									<label for="steps">
										<xsl:value-of select="$stepsLabel"/>
									</label>
									<input type="text" name="steps" min="1" value="{$stepsNumber}" step="1" id="stepsNumber" onchange="changeStepsNumber()"/>
								</div>
								<div>
									<label for="final">
										<xsl:value-of select="$finalLabel"/>
									</label>
									<select id="final" onchange="changeFinal()">
										<option value="0">
											<xsl:value-of select="$finalOption0"/>
										</option>
										<option value="1">
											<xsl:value-of select="$finalOption1"/>
										</option>
										<option value="2">
											<xsl:value-of select="$finalOption2"/>
										</option>
										<option value="3">
											<xsl:value-of select="$finalOption3"/>
										</option>
									</select>
								</div>
								<div>
									<label for="animation">
										<xsl:value-of select="$animationLabel"/>
									</label>
									<select id="animation" onchange="changeAnimation()">
										<option value="0">
											<xsl:value-of select="$animationOption0"/>
										</option>
										<option value="1">
											<xsl:value-of select="$animationOption1"/>
										</option>
									</select>
								</div>
							</fieldset>
						</form>
					</div>
				</div>
				<div id="slabControl">
					<form action="">
						<fieldset class="decoration">
							<div>
								<input type="range" min="0" max="360" step="1" length="61" value="50" onchange="setTextHue()" id="rangeHue"/>
							</div>
							<div>
								<label for="textHue">
									<xsl:value-of select="$textHueLabel"/>
								</label>
								<input type="number" name="hue" min="0" max="360" step="1" value="50" id="textHue" onchange="setRangeHue()"/>
							</div>
							<div>
								<label for="textSpheresNbr">
									<xsl:value-of select="$textSpheresNbrLabel"/>
								</label>
								<input type="number" min="0" name="sphereNbr" step="1" value="50" id="textSpheresNbr"/>
							</div>
							<div>
								<input class="light" type="radio" value="space" name="slab" id="space_radio"/>
								<label class="light" for="space_radio">
									<img src="../benchmark/icons/space.png" alt="slab"/>
								</label>
								<input class="light" type="radio" value="slab" name="slab" id="slab_radio" checked="checked"/>
								<label class="light" for="slab_radio">
									<img src="../benchmark/icons/slab.png" alt="slab"/>
								</label>
								<input class="light" type="radio" value="sphere" name="slab" id="sphere_radio"/>
								<label class="light" for="sphere_radio">
									<img src="../benchmark/icons/sphere.png" alt="sphere"/>
								</label>
								<input class="light" type="radio" value="agent_0" name="slab" id="agent_0_radio"/>
								<label class="light" for="agent_0_radio">
									<img src="../benchmark/icons/agent_0.png" alt="agent_0"/>
								</label>
								<input class="light" type="radio" value="agent_90" name="slab" id="agent_90_radio"/>
								<label class="light" for="agent_90_radio">
									<img src="../benchmark/icons/agent_90.png" alt="agent_90"/>
								</label>
								<input class="light" type="radio" value="agent_180" name="slab" id="agent_180_radio"/>
								<label class="light" for="agent_180_radio">
									<img src="../benchmark/icons/agent_180.png" alt="agent_180"/>
								</label>
								<input class="light" type="radio" value="agent_270" name="slab" id="agent_270_radio"/>
								<label class="light" for="agent_270_radio">
									<img src="../benchmark/icons/agent_270.png" alt="agent_270"/>
								</label>
							</div>
						</fieldset>
					</form>
				</div>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="buildSpaces">
		<xsl:param name="x"/>
		<xsl:param name="y"/>
		<xsl:choose>
			<xsl:when test="key('slabKey',concat($x,$y))">
				<svg:use class="space nohover" xlink:href="#space" transform="translate ({($x - $y)*$dx + $shiftX}, {($x + $y + 1)*$dy })" id="{$x}_{$y}"/>
			</xsl:when>
			<xsl:otherwise>
				<svg:use class="space" xlink:href="#space" transform="translate ({($x - $y)*$dx + $shiftX}, {($x + $y + 1)*$dy })" id="{$x}_{$y}" onclick="addSlab()"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$yMax + 1 = $y and $xMax + 1 = $x"/>
			<xsl:when test="$xMax + 1 = $x">
				<xsl:call-template name="buildSpaces">
					<xsl:with-param name="x" select="0"/>
					<xsl:with-param name="y" select="$y + 1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="buildSpaces">
					<xsl:with-param name="x" select="$x + 1"/>
					<xsl:with-param name="y" select="$y"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="buildAgentAndOthers">
		<xsl:param name="agent"/>
		<xsl:variable name="xt" select="(@x - @y)*$dx + $shiftX"/>
		<xsl:variable name="yt" select="(@x + @y + 1)*$dy - 16"/>
		<xsl:variable name="numberAgent">
			<xsl:value-of select="count($agent/preceding-sibling::*[@direction]) "/>
		</xsl:variable>
		<xsl:variable name="hue" select="($agentsNbr - $numberAgent ) * 360 div ($agentsNbr)"/>
		<xsl:variable name="id" select="concat(@x,'x',@y)"/>
		<svg:g transform="translate ({$xt}, {$yt})" onclick="onClickAgent({$agent/@direction})" id="{$id}" onmousedown="mouseDownAgent()">
			<svg:use xlink:href="#slab" class="select" fill="hsl({@hue}, 100%, 50%)" y="16"/>
			<xsl:if test="key('sphereKey',@id)">
				<svg:use xlink:href="#sphere" y="16"/>
			</xsl:if>
			<svg:g>
				<svg:use xlink:href="#body"/>
				<xsl:choose>
					<xsl:when test="$agent/ws:turn_right">
						<xsl:choose>
							<xsl:when test="$agent/@direction = 90">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M -50,0 L 0,24 L 26,-11 Z" to="M 0,-24 L -50,0 L 26,11 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
							<xsl:when test="$agent/@direction = 180">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M 26,11 L -50,0 L 0,-24 Z" to="M -26,11 L 0,-24 L 50,0 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
							<xsl:when test="$agent/@direction = 270">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M -26,11 L 0,-24 L 50,0 Z" to="M -26,-11 L 50,0 L 0,24 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
							<xsl:when test="$agent/@direction = 0">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M -26,-11 L 50,0 L 0,24 Z" to="M 26,-11 L 0,24 L -50,0 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$agent/ws:turn_left">
						<xsl:choose>
							<xsl:when test="$agent/@direction = 0">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M 0,-24 L -50,0 L 26,11 Z" to="M -50,0 L 0,24 L 26,-11 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
							<xsl:when test="$agent/@direction = 90">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M -26,11 L 0,-24 L 50,0 Z" to="M 26,11 L -50,0 L 0,-24 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
							<xsl:when test="$agent/@direction = 180">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M -26,-11 L 50,0 L 0,24 Z" to="M -26,11 L 0,-24 L 50,0 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
							<xsl:when test="$agent/@direction = 270">
								<svg:path transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)" class="head">
									<svg:animate attributeName="d" attributeType="XML" from="M 26,-11 L 0,24 L -50,0 Z" to="M -26,-11 L 50,0 L 0,24 Z" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
								</svg:path>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<svg:use xlink:href="#head_{$agent/@direction}" transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)"/>
					</xsl:otherwise>
				</xsl:choose>
			</svg:g>
			<svg:animateTransform attributeName="transform" type="translate" values="{$xt},{$yt};{$xt},{$yt - 10}" begin="mouseover" dur="0.3s" fill="freeze"/>
			<svg:animateTransform attributeName="transform" type="translate" values="{$xt},{$yt - 10};{$xt},{$yt + 5};{$xt},{$yt}" begin="mouseout" dur="0.3s" fill="freeze"/>
		</svg:g>
		<xsl:variable name="scale" select="($wView*($wView &gt;= $hView) + $hView*not($wView &gt;=$hView))"/>
		<svg:g opacity="0">
			<svg:text x="{$wView div 2}" y="{- $dy + 5}" font-size="{$scale*0.02}">
				<xsl:value-of select="$agentLabel"/>
				<xsl:value-of select="$numberAgent + 1"/>
				<xsl:value-of select="$spheresNbrLabel"/>
				<xsl:value-of select="$agent/ws:sphere/@number"/>
			</svg:text>
			<svg:line x1="{$wView div 2}" y1="{- $dy + 6}" x2="{$xt}" y2="{$yt - 10}" stroke-width="{$scale * 0.002}"/>
			<svg:animate attributeName="opacity" type="CSS" from="0" to="1" begin="{$id}.mouseover" dur="0.7s" fill="freeze"/>
			<svg:animate attributeName="opacity" type="CSS" to="0" begin="{$id}.mouseout" dur="0.3s" fill="freeze"/>
		</svg:g>
	</xsl:template>
	<xsl:template name="buildAgentAlone">
		<xsl:variable name="slab" select="key('slabKey',@on)"/>
		<xsl:variable name="xt" select="($slab/@x - $slab/@y) * $dx + $shiftX"/>
		<xsl:variable name="yt" select="($slab/@x + $slab/@y + 1) * $dy - 16"/>
		<xsl:variable name="numberAgent">
			<xsl:value-of select="count(preceding-sibling::*[@direction])"/>
		</xsl:variable>
		<xsl:variable name="hue" select="($agentsNbr - $numberAgent) * 360 div ($agentsNbr)"/>
		<xsl:variable name="id" select="concat($slab/@x,'x',$slab/@y)"/>
		<svg:g transform="translate ({$xt}, {$yt})" onclick="onClickAgent({@direction})" id="{$id}">
			<svg:g>
				<svg:use xlink:href="#body"/>
				<svg:use xlink:href="#head_{@direction}" transform="scale(0.5)" stroke="hsl({$hue}, 100%, 50%)"/>
				<xsl:variable name="old_x" select="key('slabKey',ws:advance/@old_on)/@x"/>
				<xsl:variable name="old_y" select="key('slabKey',ws:advance/@old_on)/@y"/>
				<svg:animateTransform attributeName="transform" type="translate" from="{($old_x - $old_y) * $dx + $shiftX -$xt}, {($old_x + $old_y + 1) * $dy - 16 - $yt}" to="0, 0" begin="0" dur="{$dur}s" restart="never" fill="freeze"/>
			</svg:g>
		</svg:g>
	</xsl:template>
	<xsl:template name="buildAgentBlock">
		<xsl:param name="agent"/>
		<xsl:variable name="xt" select="(@x - @y)*$dx + $shiftX"/>
		<xsl:variable name="yt" select="(@x + @y + 1)*$dy - 16"/>
		<xsl:variable name="id" select="concat(@x,'x',@y)"/>
		<svg:g transform="translate ({$xt}, {$yt})" onclick="onClickAgent({$agent/@direction})" id="{$id}">
			<svg:use xlink:href="#slab" class="select" fill="hsl({@hue}, 100%, 50%)" y="16"/>
			<svg:g>
				<svg:use xlink:href="#block"/>
			</svg:g>
			<svg:animateTransform attributeName="transform" type="translate" values="{$xt},{$yt};{$xt},{$yt - 10}" begin="mouseover" dur="0.3s" fill="freeze"/>
			<svg:animateTransform attributeName="transform" type="translate" values="{$xt},{$yt - 10};{$xt},{$yt + 5};{$xt},{$yt}" begin="mouseout" dur="0.3s" fill="freeze"/>
		</svg:g>
	</xsl:template>
</xsl:stylesheet>
