<?xml version="1.0" encoding="UTF-8"?>
<program xmlns="http://www.nomoseed.org/program" name="tutorial_4">
  <header xmlns="http://www.nomoseed.org/project">
    <author>Cédric Coussinet (cedric.coussinet@nomoseed.net)</author>
    <copyright>
      <mention xml:lang="en">
        Copyright (2013) Cédric Coussinet
      </mention>
    </copyright>
    <license name="GPLv3">
      <mention xml:lang="en">
        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published
        by the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.
        
        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
        GNU General Public License for more details.
        
        You should have received a copy of the GNU General Public License
        along with this program. If not, see http://www.gnu.org/licenses 
      </mention>
    </license>
    <datetime>2014-06-28T16:28:51Z</datetime>
    <version/>
    <annotation>
      <documentation xml:lang="fr">
        Programme correspondant au exemple du tutoriel portant sur les propriétés élémentaires.
      </documentation>
    </annotation>
  </header>
  <body>
    <models xmlns:xi="http://www.w3.org/2001/XInclude">
      <new instance="tutorial_4">
        <xi:include href="tutorial_4.mod" parse="xml"/>
      </new>
    </models>
    <scheme xmlns="http://www.nomoseed.org/program">
      <scheme name="base">
        <rule name="advance">
          <conclusion model="tutorial_4" category="command" type="motor">
            <information value="advance"/>
            <output value="2"/>
          </conclusion>
        </rule>
        <rule name="detect_anomaly">
          <premise model="plant" category="anomaly" type="anomaly">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="command" type="sound">
            <information value="red"/>
            <output value="0"/>
          </conclusion>
        </rule>
        <rule name="detect_reward">
          <premise model="tutorial_4" category="reward" type="hue">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="1" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="command" type="sound">
            <information value="blue"/>
            <output value="200"/>
          </conclusion>
        </rule>
        <rule name="hue_blue">
          <premise model="tutorial_4" category="input" type="hue">
            <information value="200" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="perception" type="hue">
            <information value="blue"/>
          </conclusion>
        </rule>
      </scheme>
      <scheme name="first_phase">
        <scheme name="affectation">
          <rule name="begin_affectation_1">
            <premise model="tutorial_4" category="perception" type="hue">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="0"/>
            </premise>
            <premise model="plant" category="transition" type="transition" inhibitor="true">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="INF"/>
            </premise>
            <premise model="tutorial_4" category="prediction" type="hue" inhibitor="true">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <conclusion model="plant" category="transition" type="transition">
              <information value="begin_affectation"/>
            </conclusion>
          </rule>
          <rule name="scope_hue_1">
            <premise model="tutorial_4" category="perception" type="hue">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="0"/>
            </premise>
            <premise model="plant" category="transition" type="transition" inhibitor="true">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="INF"/>
            </premise>
            <premise model="tutorial_4" category="prediction" type="hue" inhibitor="true">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <conclusion model="tutorial_4" category="scope" type="register_01">
              <information value="hue"/>
            </conclusion>
          </rule>
          <rule name="scope_hue_2">
            <premise model="tutorial_4" category="perception" type="hue">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <premise model="tutorial_4" category="perception" type="hue">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="0" tolerance="INF"/>
            </premise>
            <premise model="tutorial_4" category="scope" type="register_01">
              <information value="hue" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="INF"/>
            </premise>
            <premise model="tutorial_4" category="scope" type="register_02" inhibitor="true">
              <information value="hue" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="INF"/>
            </premise>
            <premise model="tutorial_4" category="prediction" type="hue" inhibitor="true">
              <information tolerance="INF"/>
              <credibility tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <conclusion model="tutorial_4" category="scope" type="register_02">
              <information value="hue"/>
            </conclusion>
          </rule>
          <rule name="copy_hue_1">
            <premise model="tutorial_4" category="scope" type="register_02">
              <information value="hue" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="plant" category="operator" type="register_01">
              <information value="get_there"/>
            </conclusion>
          </rule>
          <rule name="copy_hue_2">
            <premise model="tutorial_4" category="scope" type="register_02">
              <information value="hue" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="plant" category="operator" type="register_02">
              <information value="get_there"/>
            </conclusion>
          </rule>
          <rule name="target_reference_1">
            <premise model="plant" category="operator" type="register_01">
              <information value="get_there" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="plant" category="operator" type="register_01">
              <information value="transform_in_temporal_reference_and_origin"/>
            </conclusion>
          </rule>
          <scheme name="predictive_structure">
            <rule name="create_prediction">
              <premise model="plant" category="operator" type="register_02">
                <information value="get_there" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_03">
                <information value="create_prediction"/>
              </conclusion>
            </rule>
            <rule name="target_prediction">
              <premise model="plant" category="operator" type="register_02">
                <information value="get_there" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_02">
                <information value="target"/>
              </conclusion>
            </rule>
            <rule name="create_landmark">
              <premise model="plant" category="operator" type="register_03">
                <information value="create_prediction" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_04">
                <information value="create_landmark"/>
              </conclusion>
            </rule>
            <rule name="target_landmark">
              <premise model="plant" category="operator" type="register_03">
                <information value="create_prediction" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_02">
                <information value="target"/>
              </conclusion>
            </rule>        
            <rule name="forward_1">
              <premise model="plant" category="operator" type="register_04">
                <information value="create_landmark" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_04">
                <information value="forward"/>
              </conclusion>
            </rule>
            <rule name="target_forward_1">
              <premise model="plant" category="operator" type="register_04">
                <information value="create_landmark" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_01">
                <information value="target"/>
              </conclusion>
            </rule>
            <rule name="create_check">
              <premise model="plant" category="operator" type="register_04">
                <information value="create_landmark" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="1" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_05">
                <information value="create_check_forward"/>
              </conclusion>
            </rule>
            <rule name="target_check">
              <premise model="plant" category="operator" type="register_04">
                <information value="create_landmark" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="1" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_02">
                <information value="target"/>
              </conclusion>
            </rule>
            <rule name="create_reward">
              <premise model="plant" category="operator" type="register_05">
                <information value="create_check_forward" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_06">
                <information value="create_reward"/>
              </conclusion>
            </rule>
            <rule name="target_reward">
              <premise model="plant" category="operator" type="register_05">
                <information value="create_check_forward" tolerance="0"/>
                <credibility tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="plant" category="operator" type="register_05">
                <information value="target"/>
              </conclusion>
            </rule>
          </scheme>
        </scheme>  
        <scheme name="building">
          <rule name="begin_inhibition_1">
            <premise model="plant" category="operator" type="register_06">
              <information value="create_reward" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="plant" category="transition" type="transition">
              <information value="begin_inhibition"/>
            </conclusion>
          </rule>
          <rule name="create_premise_inhibition">
            <premise model="plant" category="operator" type="register_06">
              <information value="create_reward" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="tutorial_4" category="operator" type="register_03">
              <information value="create_premise_prediction"/>
            </conclusion>
          </rule>
          <rule name="begin_excitation_1">
            <premise model="plant" category="operator" type="register_06">
              <information value="create_reward" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="0"/>
            </premise>
            <conclusion model="plant" category="transition" type="transition">
              <information value="begin_excitation"/>
            </conclusion>
          </rule>
          <rule name="create_premise_1">
            <premise model="plant" category="operator" type="register_06">
              <information value="create_reward" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="1" tolerance="0"/>
            </premise>
            <conclusion model="tutorial_4" category="operator" type="register_01">
              <information value="create_premise_1"/>
            </conclusion>
          </rule>
          <rule name="begin_finalization_1">
            <premise model="plant" category="operator" type="register_06">
              <information value="create_reward" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="2" tolerance="0"/>
            </premise>
            <conclusion model="plant" category="transition" type="transition">
              <information value="begin_finalization"/>
            </conclusion>
          </rule>
          <rule name="create_conclusion_prediction">
            <premise model="plant" category="operator" type="register_06">
              <information value="create_reward" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="2" tolerance="0"/>
            </premise>
            <conclusion model="tutorial_4" category="operator" type="register_03">
              <information value="create_conclusion_1"/>
            </conclusion>
          </rule>
          <rule name="create_conclusion_landmark">
            <premise model="plant" category="operator" type="register_06">
              <information value="create_reward" tolerance="0"/>
              <credibility tolerance="INF"/>
              <timespan value="3" tolerance="0"/>
            </premise>
            <conclusion model="tutorial_4" category="operator" type="register_04">
              <information value="create_conclusion_1"/>
            </conclusion>
          </rule>
        </scheme>
      </scheme>
      <scheme name="second_phase">
        <rule name="begin_affectation_2">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="4" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="transition" type="transition">
            <information value="begin_affectation"/>
          </conclusion>
        </rule>
        <rule name="forward_reward">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="4" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_06">
            <information value="forward"/>
          </conclusion>
        </rule>
        <rule name="forward_2">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="5" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_04">
            <information value="forward"/>
          </conclusion>
        </rule>
        <rule name="target_forward_2">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="5" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_01">
            <information value="target"/>
          </conclusion>
        </rule>
        <rule name="backward_1">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="6" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_01">
            <information value="backward"/>
          </conclusion>
        </rule>
        <rule name="target_backward_1">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="6" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_05">
            <information value="target"/>
          </conclusion>
        </rule>
        <rule name="forward_3">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="7" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_03">
            <information value="forward"/>
          </conclusion>
        </rule>
        <rule name="target_reference_2">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="7" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_02">
            <information value="transform_in_temporal_reference_and_origin"/>
          </conclusion>
        </rule>
        <rule name="begin_excitation_2">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="8" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="transition" type="transition">
            <information value="begin_excitation"/>
          </conclusion>
        </rule>
        <rule name="create_premise_prediction">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="8" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="operator" type="register_03">
            <information value="create_premise_prediction"/>
          </conclusion>
        </rule>
        <rule name="create_premise_landmark">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="8" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="operator" type="register_04">
            <information value="create_premise_landmark"/>
          </conclusion>
        </rule>
        <rule name="create_premise_target">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="8" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="operator" type="register_02">
            <information value="create_premise_1"/>
          </conclusion>
        </rule>
        <rule name="begin_finalization_2">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="9" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="transition" type="transition">
            <information value="begin_finalization"/>
          </conclusion>
        </rule>
        <rule name="create_conclusion_check">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="9" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="operator" type="register_05">
            <information value="create_conclusion_1"/>
          </conclusion>
        </rule>
      </scheme>
      <scheme name="last_phase">
        <rule name="begin_affectation_3">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="10" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="transition" type="transition">
            <information value="begin_affectation"/>
          </conclusion>
        </rule>
        <rule name="target_reference_3">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="10" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="operator" type="register_06">
            <information value="transform_in_temporal_reference_and_origin"/>
          </conclusion>
        </rule>
        <rule name="begin_excitation_3">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="11" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="transition" type="transition">
            <information value="begin_excitation"/>
          </conclusion>
        </rule>
        <rule name="create_premise_check">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="11" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="operator" type="register_05">
            <information value="create_premise_1"/>
          </conclusion>
        </rule>
        <rule name="begin_finalization_3">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="12" tolerance="0"/>
          </premise>
          <conclusion model="plant" category="transition" type="transition">
            <information value="begin_finalization"/>
          </conclusion>
        </rule>
        <rule name="create_conclusion_reward">
          <premise model="plant" category="operator" type="register_06">
            <information value="create_reward" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="12" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_4" category="operator" type="register_06">
            <information value="create_conclusion_1"/>
          </conclusion>
        </rule>
      </scheme>
    </scheme>
  </body>
</program>
