<?xml version="1.0" encoding="UTF-8"?>
<model xmlns="http://www.nomoseed.org/model" name="worldsquare">
  <header xmlns="http://www.nomoseed.org/project">
    <author>Cédric Coussinet (cedric.coussinet@nomoseed.net)</author>
    <copyright>
      <mention xml:lang="en">
  Copyright (2013) Cédric Coussinet
      </mention>
    </copyright>
    <license name="GPLv3">
      <mention xml:lang="en">
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see http://www.gnu.org/licenses
      </mention>
    </license>
    <datetime>2013-05-22T09:22:58Z</datetime>
    <version>1.0</version>
    <annotation>
      <documentation xml:lang="fr">
        Le modèle "Worldsquare" est utilisé dans le cadre des environements virtuels de type Worldsquare implanté dans nomoSDK.
      </documentation>
    </annotation>
  </header>
  <definition>
    <annotation xmlns="http://www.nomoseed.org/project">
      <documentation xml:lang="fr">
        Le modèle Worldsquare définit les entrées et les sorties d'un agent dans un monde de type Worldsquare, monde plan constitué de dalles sur lesquels une sphére peut être présente.
      </documentation>
    </annotation>
    <command_type name="motor">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          Les commandes motrices portent sur le déplacement de l'agent et la capacité à capturer des sphères.
        </documentation>
      </annotation>
      <items>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="fr">
            Quatre actions liées au déplacement sont définies.
          </documentation>
        </annotation>
        <item name="advance">
          <annotation xmlns="http://www.nomoseed.org/project">
            <documentation xml:lang="fr">
              Commande d'avancer sur la dalle placée devant.
            </documentation>
          </annotation>
        </item>
        <item name="turn_left">
          <annotation xmlns="http://www.nomoseed.org/project">
            <documentation xml:lang="fr">
              Commande de tourner sur place de 90° à gauche.
            </documentation>
          </annotation>
        </item>
        <item name="turn_right">
          <annotation xmlns="http://www.nomoseed.org/project">
            <documentation xml:lang="fr">
              Commande de tourner sur place de 90° à droite.
            </documentation>
          </annotation>
        </item>
        <item name="capture">
          <annotation xmlns="http://www.nomoseed.org/project">
            <documentation xml:lang="fr">
              Commande de capturer sur place la sphère présente.
            </documentation>
          </annotation>
        </item>
        <item name="depose">
          <annotation xmlns="http://www.nomoseed.org/project">
            <documentation xml:lang="fr">
              Commande de déposer sur place une sphère.
            </documentation>
          </annotation>
        </item>
      </items>
      <components>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="fr">
            Chaque commande motrice correspond à un nombre entier.
          </documentation>
        </annotation>
        <component name="value"/>
      </components>
    </command_type>
    <perceptive_structure name="hue">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          La structure perceptive "hue" correspond à la captation de la teinte sur la dalles où se trouve l'agent.
        </documentation>
      </annotation>
      <items/>
      <components>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="fr">
            La teinte est codé sur 360 degrés avec des nombres entiers.
          </documentation>
        </annotation>
        <component name="value"/>
      </components>
    </perceptive_structure>
    <perceptive_structure name="spheres_number">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          La structure perceptive "spheres_number" représente la quatité de sphères possédés par l'agent.
        </documentation>
      </annotation>
      <items/>
      <components>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="fr">
            La teinte est codé avec une seule composente
          </documentation>
        </annotation>
        <component name="value"/>
      </components>
    </perceptive_structure>
    <perceptive_structure name="strength">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          La structure perceptive "strength" correspond à la résistance à se déplacer, soit à l'échec de la commande d'avancer.
        </documentation>
      </annotation>
      <items>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="fr">
            Perception de l'échec de la commande motrice "advance".
          </documentation>
        </annotation>
        <item name="failed"/>
      </items>
      <components>
        <component name="value"/>
      </components>
    </perceptive_structure>
    <perceptive_structure name="random">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          La structure perceptive "random" correspond à une variable aléatoire en 0 et 1.
        </documentation>
      </annotation>
      <items/>
      <components>
        <component name="value"/>
      </components>
    </perceptive_structure>
    <perceptive_structure name="sound">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          La structure perceptive "sound" correspond à la captation du son. Le son est codé sur 360 degrés avec des nombres entiers.
        </documentation>
      </annotation>
      <command_type>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="fr">
            Les commandes de haut-parleur correspond à la production sonor.
          </documentation>
        </annotation>
        <items/>
      </command_type>
      <items/>
      <components>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="fr">
            La teinte est codé avec une seule composente
          </documentation>
        </annotation>
        <component name="value"/>
      </components>
    </perceptive_structure>
    <perceptive_structure name="sonar">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          La structure perceptive "sonar" correspond à la détection d'un obstacle dans les quatre directions quelque soit la distance. Il y a 2**4 configurations possibles.
        </documentation>
      </annotation>
      <items/>
      <components>
        <component name="left"/>
        <component name="front"/>
        <component name="right"/>
        <component name="back"/>
      </components>
    </perceptive_structure>
    <perceptive_structure name="bumper">
      <annotation xmlns="http://www.nomoseed.org/project">
        <documentation xml:lang="fr">
          La structure perceptive "bumper" correspond à la détection de la présence de dalles connexes dans les quatre directions.
        </documentation>
      </annotation>
      <items/>
      <components>
        <component name="left"/>
        <component name="front"/>
        <component name="right"/>
        <component name="back"/>
      </components>
    </perceptive_structure>
  </definition>
</model>
