--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private with Nomo.Gen_Rule_Storages;

private with Nomo.Interpreter.Premises_Index.Arrays;

private with Nomo.Interpreter.External_Messages.Premises;

private with Nomo.Interpreter.Components_Index;

private with Nomo.Interpreter.Types_Index.Ranges;

private package Nomo.Interpreter.Storages is

   type Full_Rule_Storage is limited private;

   Partial_Storage_Size : constant Positive;

private

   use Premises_Index.Premises_Index_Instance;
   use Components_Index.Components_Index_Instance;
   use Types_Index.Ranges;
   use Premises_Index.Arrays;
   use External_Messages;
   use External_Messages.Premises;

   package Rule_Storages_Instance is new Gen_Rule_Storages(Premise_Index,
                                                           Internal_Type_Index,
                                                           External_Type_Index,
                                                           Component_Index,
                                                           Internal_Premises,
                                                           Internal_Premises_Types,
                                                           Internal_Premises_Properties,
                                                           External_Message,
                                                           External_Premise);

   type Full_Rule_Storage is new Rule_Storages_Instance.Full_Rule_Storage with null record;

   Partial_Storage_Size : constant positive := Rule_Storages_Instance.Partial_Rule_Storage'Size;

end Nomo.Interpreter.Storages;
