--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;
use Nomo.Numerics.Accurately;

with Nomo.Numerics.Times;
use Nomo.Numerics.Times;

private generic
   type Cluster is limited private;
   type Index_Type is (<>);
   with function Has_Selection (This : in Cluster) return Boolean;
   with procedure Assume (This : in out Cluster;
                          T    : in Positive_Time);
   with procedure Interpret (This : in out Cluster);
   with procedure Reinforce (This            : in out Cluster;
                             T               : in Positive_Time;
                             First_Landmark  : in Positive_Time_Interval;
                             Second_Landmark : in Positive_Time_Interval;
                             Quantity        : in Real_Accurately_0_To_1);
package Nomo.Interpreter.Epistemic_Memory.Gen_Section is

   procedure Assume (T : in Positive_Time);

   procedure Interpret;

   procedure Reinforce (I               : in Index_Type;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);

private

   This : array (Index_Type'Range) of aliased Cluster;

end Nomo.Interpreter.Epistemic_Memory.Gen_Section;
