<?xml version="1.0" encoding="utf-8" ?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Transforme une unité de compilation suivant une grammaire basique ambigue en une unité respectant une grammaire non ambigu.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:unit="http://www.nomoseed.org/unit" xmlns:program="http://www.nomoseed.org/program" xmlns:inference_engine="http://www.nomoseed.org/inference_engine" xmlns:knowledge_base="http://www.nomoseed.org/knowledge_base" xmlns:project="http://www.nomoseed.org/project">
	<xsl:output method="xml" indent="yes"/>
	<xsl:include href="link_0-program.xsl"/>
	<xsl:include href="link_0-base.xsl"/>
	<xsl:template match="unit:unit">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="multiplexer">
				<xsl:value-of select="@multiplexer"/>
			</xsl:attribute>
			<xsl:attribute name="binaryLocation">
				<xsl:value-of select="@binaryLocation"/>
			</xsl:attribute>
      <xsl:if test="@xml:base">
        <xsl:attribute name="xml:base">
          <xsl:value-of select="@xml:base"/>
        </xsl:attribute>
      </xsl:if>
			<xsl:apply-templates select="inference_engine:inference_engine"/>
			<xsl:apply-templates select="knowledge_base:knowledge_base"/>
			<xsl:apply-templates select="program:program"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="*">
		<xsl:copy-of select="."/>
	</xsl:template>
</xsl:stylesheet>


