<?xml version="1.0" encoding="UTF-8"?>
<program xmlns="http://www.nomoseed.org/program" name="agent">
  <header xmlns="http://www.nomoseed.org/project">
    <author>Cédric Coussinet (cedric.coussinet@nomoseed.net)</author>
    <copyright>
      <mention xml:lang="en">
        Copyright (2013) Cédric Coussinet
      </mention>
    </copyright>
    <license name="GPLv3">
      <mention xml:lang="en">
        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published
        by the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.
        
        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
        GNU General Public License for more details.
        
        You should have received a copy of the GNU General Public License
        along with this program. If not, see http://www.gnu.org/licenses
      </mention>
    </license>
    <datetime>2014-04-15T13:29:09Z</datetime>
    <version>0.0</version>
    <annotation>
      <documentation xml:lang="fr">Quel est le contexte ?</documentation>
    </annotation>
  </header>
  <subprograms xmlns:xi="http://www.w3.org/2001/XInclude">
    <inherite instance="switch">
      <xi:include href="switch_on.prg"/>
    </inherite>
    <new instance="controller">
      <xi:include href="controller.prg"/>
    </new>
  </subprograms>
  <body>
    <models xmlns:xi="http://www.w3.org/2001/XInclude">
      <inherite instance="switch">
        <xi:include href="switch.mod"/>
      </inherite>
      <new instance="agent">
        <xi:include href="agent.mod"/>
      </new>
      <import instance="controller" subprogram="controller">
        <xi:include href="controller.prg#xmlns(model=http://www.nomoseed.org/model)xpointer((//model:model[@name='controller'])[1])"/>
      </import>
    </models>
    <scheme xmlns="http://www.nomoseed.org/program">
<scheme name="events">
<scheme name="found">
<rule name="id1969432">
<premise model="agent" category="perception" type="hue">
<information value="blue" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="controller" category="conception" type="event">
<information value="found"/>
</conclusion>
</rule>
<rule name="id1969464">
<premise model="agent" category="perception" type="strength" inhibitor="true">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="agent" category="command" type="motor">
<information value="capture" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="500 ms" tolerance="0"/>
</premise>
<conclusion model="controller" category="conception" type="event">
<information value="found"/>
</conclusion>
</rule>
</scheme>
<scheme name="no_found">
<rule name="id1969514">
<premise model="agent" category="perception" type="strength">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="controller" category="conception" type="event">
<information value="no_found"/>
</conclusion>
</rule>
<rule name="id1969544">
<premise model="agent" category="perception" type="hue">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="controller" category="conception" type="event">
<information value="no_found"/>
</conclusion>
</rule>
<rule name="id1969574">
<premise model="agent" category="command" type="motor">
<information value="turn_left" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="controller" category="conception" type="event">
<information value="no_found"/>
</conclusion>
</rule>
<rule name="id1969605">
<premise model="agent" category="command" type="motor">
<information value="turn_right" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="controller" category="conception" type="event">
<information value="no_found"/>
</conclusion>
</rule>
</scheme>
<rule name="switched_to_on">
          <premise model="switch" category="conception" type="switch">
            <information value="on" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="controller" category="conception" type="event">
            <information value="switched_to_on"/>
          </conclusion>
        </rule>
<rule name="switched_to_off">
          <premise model="switch" category="conception" type="switch">
            <information value="off" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="controller" category="conception" type="event">
            <information value="switched_to_off"/>
          </conclusion>
        </rule>
</scheme>
<scheme name="perceptions">
<scheme name="random">
<rule name="random_1">
<premise model="controller" category="conception" type="state">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="controller" category="conception" type="state" inhibitor="true">
<information value="terminate" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="controller" category="conception" type="state" inhibitor="true">
<information value="start" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="agent" category="input" type="random">
<information tolerance="2.50000E-01" value="-5.55112E-17"/>
</premise>
<conclusion model="agent" category="perception" type="random">
<information value="small"/>
</conclusion>
</rule>
<rule name="random_2">
<premise model="controller" category="conception" type="state">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="controller" category="conception" type="state" inhibitor="true">
<information value="terminate" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="controller" category="conception" type="state" inhibitor="true">
<information value="start" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="agent" category="input" type="random">
<information tolerance="2.50000E-01" value="5.00000E-01"/>
</premise>
<conclusion model="agent" category="perception" type="random">
<information value="middle"/>
</conclusion>
</rule>
<rule name="random_3">
<premise model="controller" category="conception" type="state">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="controller" category="conception" type="state" inhibitor="true">
<information value="terminate" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="controller" category="conception" type="state" inhibitor="true">
<information value="start" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="agent" category="input" type="random">
<information tolerance="2.50000E-01" value="1.00000E+00"/>
</premise>
<conclusion model="agent" category="perception" type="random">
<information value="large"/>
</conclusion>
</rule>
</scheme>
<scheme name="hue">
<rule name="hue_1">
<premise model="controller" category="conception" type="state">
<information value="search_location" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="-1" tolerance="INF"/>
</premise>
<premise model="agent" category="command" type="motor">
<information value="advance" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="1" tolerance="0"/>
</premise>
<premise model="agent" category="perception" type="strength" inhibitor="true">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="agent" category="input" type="hue">
<information tolerance="2.40000E+02" value="1.80000E+02"/>
</premise>
<conclusion model="agent" category="perception" type="hue">
<information value="red"/>
</conclusion>
</rule>
<rule name="hue_2">
<premise model="controller" category="conception" type="state">
<information value="search_location" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="-1" tolerance="INF"/>
</premise>
<premise model="agent" category="command" type="motor">
<information value="advance" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="1" tolerance="0"/>
</premise>
<premise model="agent" category="perception" type="strength" inhibitor="true">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="agent" category="input" type="hue">
<information tolerance="2.86957E+01" value="1.20858E+02"/>
</premise>
<conclusion model="agent" category="perception" type="hue">
<information value="green"/>
</conclusion>
</rule>
<rule name="hue_3">
<premise model="controller" category="conception" type="state">
<information value="search_location" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="-1" tolerance="INF"/>
</premise>
<premise model="agent" category="command" type="motor">
<information value="advance" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="1" tolerance="0"/>
</premise>
<premise model="agent" category="perception" type="strength" inhibitor="true">
<information tolerance="INF"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<premise model="agent" category="input" type="hue">
<information tolerance="2.86957E+01" value="2.39142E+02"/>
</premise>
<conclusion model="agent" category="perception" type="hue">
<information value="blue"/>
</conclusion>
</rule>
</scheme>
<rule name="strength">
          <premise model="agent" category="input" type="strength">
            <information tolerance="INF"/>
          </premise>
          <conclusion model="agent" category="perception" type="strength">
            <information value="failed"/>
          </conclusion>
        </rule>
</scheme>
<scheme name="actions">
<scheme name="explore">
<rule name="motor_1">
<premise model="agent" category="perception" type="random">
<information value="middle" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="agent" category="command" type="motor">
<information value="advance"/>
<output value="2"/>
</conclusion>
</rule>
<rule name="motor_2">
<premise model="agent" category="perception" type="random">
<information value="small" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="agent" category="command" type="motor">
<information value="turn_left"/>
<output value="0"/>
</conclusion>
</rule>
<rule name="motor_3">
<premise model="agent" category="perception" type="random">
<information value="large" tolerance="0"/>
<credibility tolerance="INF"/>
<timespan value="0" tolerance="0"/>
</premise>
<conclusion model="agent" category="command" type="motor">
<information value="turn_right"/>
<output value="1"/>
</conclusion>
</rule>
</scheme>
<rule name="search_sphere">
          <premise model="controller" category="conception" type="state">
            <information value="search_sphere" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <premise model="agent" category="command" type="motor">
            <information value="advance" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="1" tolerance="0"/>
          </premise>
          <premise model="agent" category="perception" type="strength" inhibitor="true">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="agent" category="command" type="motor">
            <information value="capture"/>
            <output value="3"/>
          </conclusion>
        </rule>
<rule name="terminate">
          <premise model="controller" category="conception" type="state">
            <information value="terminate" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="agent" category="command" type="motor">
            <information value="depose"/>
            <output value="4"/>
          </conclusion>
        </rule>
</scheme>
</scheme>
  </body>
  <sdk> 
    <macro xmlns="http://www.nomoseed.org/sdk" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" active="true" name="random" scheme="perceptions" xsi:type="discretization">
      <discretization xmlns="http://www.nomoseed.org/discretization" center="true">
        <rule name="random">
          <premise model="controller" category="conception" type="state">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="controller" category="conception" type="state" inhibitor="true">
            <information value="terminate" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="controller" category="conception" type="state" inhibitor="true">
            <information value="start" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="agent" category="input" type="random">
            <information interval="small 0.25 middle 0.75 large"/>
          </premise>
          <conclusion model="agent" category="perception" type="random"/>
        </rule>
      </discretization>
    </macro>
    <macro xmlns="http://www.nomoseed.org/sdk" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" active="true" name="hue" scheme="perceptions" xsi:type="discretization">
      <discretization xmlns="http://www.nomoseed.org/discretization" center="false">
        <rule name="hue">
          <premise model="controller" category="conception" type="state">
            <information value="search_location" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <premise model="agent" category="command" type="motor">
            <information value="advance" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="1" tolerance="0"/>
          </premise>
          <premise model="agent" category="perception" type="strength" inhibitor="true">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="agent" category="input" type="hue">
            <information interval="red 60 green 180 blue 300 red"/>
          </premise>
          <conclusion model="agent" category="perception" type="hue"/>
        </rule>
      </discretization>
    </macro>
    <macro xmlns="http://www.nomoseed.org/sdk" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" active="true" name="explore" scheme="actions" xsi:type="template">
      <csv xsi:type="embedded">
        command, output, random
        advance, 2, middle
        turn_left, 0, small
        turn_right, 1, large
      </csv>
      <template xmlns="http://www.nomoseed.org/template">
        <rule name="motor">
          <premise model="agent" category="perception" type="random">
            <information value="#random" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="agent" category="command" type="motor">
            <information value="#command"/>
            <output value="#output"/>
          </conclusion>
        </rule>
      </template>
    </macro>
    <macro xmlns="http://www.nomoseed.org/sdk" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" active="true" name="found" scheme="events" xsi:type="formulation">
      <formulation xmlns="http://www.nomoseed.org/formulation">
        <declarations>
          <premise model="agent" category="perception" type="strength" name="failed">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="agent" category="command" type="motor" name="capture">
            <information value="capture" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="1" tolerance="0"/>
          </premise>
          <premise model="agent" category="perception" type="hue" name="blue_hue">
            <information value="blue" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="controller" category="conception" type="event" name="found">
            <information value="found"/>
          </conclusion>
        </declarations>
        <formulas>
          blue_hue : found
          failed ! capture : found
        </formulas>
      </formulation>
    </macro>
    <macro xmlns="http://www.nomoseed.org/sdk" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" active="true" name="no_found" scheme="events" xsi:type="formulation">
      <formulation xmlns="http://www.nomoseed.org/formulation">
        <declarations>
          <premise model="agent" category="perception" type="strength" name="failed">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="agent" category="perception" type="hue" name="other_hue">
            <information tolerance="INF"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="agent" category="command" type="motor" name="turn_left">
            <information value="turn_left" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="agent" category="command" type="motor" name="turn_right">
            <information value="turn_right" tolerance="0"/>
            <credibility tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="controller" category="conception" type="event" name="no_found">
            <information value="no_found"/>
          </conclusion>
        </declarations>
        <formulas>
          failed + other_hue + turn_right +  turn_left : no_found
        </formulas>
      </formulation>
    </macro>
  </sdk>
</program>
